function [out1,out2,out3,out4,out5]=boded(z,p,gain,T,arg5,arg6,arg7,arg8,arg9)
%BODED	  Bode semilog plots in one figure (discrete-time systems).
%   BODED(z,p,k,T,[col]) provides Bode semilog plots of the frequency
%   response function of the discrete-time SISO system (z,p,k) with
%   automatic scaling.
%   BODED(z,p,k,T,om1,[col]) provides Bode plots of the frequency
%   response function in the range om1 <= omega <= pi/T.
%   Parameter col (optional) defines color of plot; col must be a string
%   variable ('g'=green, 'b'=blue, 'r'=red, 'y'=yellow, 'c'=cyan,
%   'm'=magenta); default is col='g'.
%   External definition of axes is possible with "axis([xm,xM,ym,yM])".
%   Other uses:  [pho1,pho2]=BODED(z,p,k,T,[col])
%		 [pho1,pho2]=BODED(z,p,k,T,om1,[col])
%		 [pho1,pho2]=BODED(z,p,k,T,om1,[col,phi1,phi2])
%   where [pho1,pho2] and [phi1 phi2] are optional outputs to exchange
%   information on phase scaling for a possible second call.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

%   A finite delay to can be specified with the 6-, 7- and 9- argument calls:
%   boded(z,p,k,T,col,ko), boded(z,p,k,T,om1,col,ko),
%   boded(z,p,k,T,om1,col,phi1,phi2,ko).

global HALEG

nargs=nargin; xx=4;
error(nargchk(4,9,nargs));
if nargs==4
 col='g-'; col1='g-.';
elseif nargs==5
 if isstr(arg5)
  col=[arg5,'-']; col1=[arg5,'-.'];
 else
  om1=arg5; col='g-'; col1='g-.'; xx=5;
 end
elseif nargs==6
 if isstr(arg6)
  om1=arg5; col=[arg6,'-']; col1=[arg6,'-.']; xx=5;
 elseif isstr(arg5)
  col=[arg5,'-']; col1=[arg5,'-.']; ko=arg6;
 end
else  % (nargs==7)|(nargs==8)|(nargs==9)
 om1=arg5; col=[arg6,'-']; col1=[arg6,'-.']; xx=5;
 if nargs==7, ko=arg7; end
 if nargs==9, ko=arg9; end
end
flge=1;
if (nargs==8)|(nargs==9)
 if arg7<arg8
  phi1=arg7; phi2=arg8; flge=0;
 else
  phi1=arg8; phi2=arg7;
 end
 flgd=1;
else
 flgd=0;
end
%
[colp,colm,sty]=coltbl(col);
[tp1,tp2,tp3,tp4]=coltbl; colk=tp1(8,:);
%
if T<=0
 error('illegal sampling time in boded')
end
if xx==5 & om1<=0
 error('illegal om1 in boded')
end
if ko~=0, p=[p;zeros(ko,1)]; end
nz=length(z); np=length(p);
%
ih=ishold; YY=axis; s1=get(gca,'XLimMode');
if ih | strcmp(s1,'manual')
 om1=YY(1);
else
 if xx==4
% automatic scaling
  tol=10^(-4); zzpp=[z;p];
  vv=abs(log(zzpp+eps)/T); vv=vv(find(vv>tol)); vv=log10(abs(vv));
  if isempty(vv)
   om1=10^(floor(.001/T));
  else
   om1=10^(floor(min(vv)-2));
  end
 end
end
%
om2=pi/T; k1=log10(om1); k2=log10(om2);
j=sqrt(-1);
nw=201; w=j*ones(1,nw); w1=logspace(k1,k2,nw)+eps;
w=exp(j*w1*T); y=gain*ones(1,nw);
% correction for unwrap
for kk=1:np
 if (p(kk)~=1)&((abs(p(kk))-1)<10^(-4))
  p(kk)=p(kk)*(1-10^(-4));
 end
end
for kk=1:nz
 if (z(kk)~=1)&((abs(z(kk))-1)<10^(-4))
  z(kk)=z(kk)*(1-10^(-4));
 end
end
for kk=1:np
 y=y./(w-p(kk));
end
for kk=1:nz
 y=y.*(w-z(kk));
end
mag=abs(y)'; phi=(unwrap(angle(y))*180/pi)';
%
% correction for phase
%
[zw,pw,gainw]=diwplane(z,p,gain,T); [gg,pp]=asymph(zw,pw,gainw,w1(1),w1(nw));
kk=0;
while (abs(phi(1)-pp(1)) > 180) & (kk <= 12)
 kk=kk+1; phi=phi-360*sign(phi(1)-pp(1));
end
%
mag1=20*log10(mag);
ha=semilogx(w1,mag1,w1(1),-20,w1(1),20);
set(ha(1),'Color',colp,'LineStyle','-')
set(ha(2),'Color',colk,'LineStyle','none','Marker','.')
set(ha(3),'Color',colk,'LineStyle','none','Marker','.')
HALEG=[HALEG,ha(1)];
%
if ih
 axis(YY)
else
 if strcmp(s1,'manual')
  minga=YY(3); maxga=YY(4);
 else
  minga=min(mag1); maxga=max(mag1);
 end
 if maxga < (minga+240)
  if (maxga-minga)<20, minga=minga-20; maxga=maxga+20; end
  yym=20*floor(minga/20+10^(-4)); yyM=20*ceil(maxga/20-10^(-4));
  ytick=[yym:20:yyM];
 else
  yym=40*floor(minga/40); yyM=40*ceil(maxga/40);
  ytick=[yym:40:yyM];
 end
 set(gca,'ylim',[yym,yyM],'ytick',ytick);
end
title('diagrammi di Bode di ampiezza (-) e fase (-.)')
aat=setstr(32*ones(1,70));
aam=sprintf('ampiezza (db) e fase (gradi)');
mess=[aat(1:70-length(aam)),aam];
ylabel(mess), hold on
YY=axis; minga=YY(3); maxga=YY(4); scale=maxga-minga;
%
ytick=get(gca,'ytick'); ndiv=length(ytick)-1;
%
if (xx==4 & ~ih) | (xx==5 & flge)
 if flgd==1
  minph=round(phi1); maxph=round(phi2);
 else
  minph=min(phi); maxph=max(phi);
 end
 minph=30*floor(minph/30+10^(-4)); maxph=30*ceil(maxph/30-10^(-4));
 if (maxph-minph)<=180, minstp=7.5; else, minstp=15; end
 divph=ceil((maxph-minph)/minstp);
 kk=1;
 while divph>ndiv
  kk=kk+1;
  divph=ceil((maxph-minph)/(minstp*kk));
 end
 sstep=minstp*kk; scaleph=ndiv*sstep; minph=maxph-scaleph;
 phi1=minph; phi2=maxph; stepga=scale/ndiv;
 xxt=10^(log10(YY(2))+.02*(log10(YY(2))-log10(YY(1))));
 text(xxt,minga,sprintf('%.5g',minph))
 for kk=1:ndiv
  text(xxt,minga+kk*stepga,sprintf('%.5g',minph+kk*sstep))
 end
 aat=setstr(32*ones(1,120)); aam=sprintf('rad/sec');
 mess=[aat(1:120-length(aam)),aam]; xlabel(mess)
end
%
scaleph=phi2-phi1; phic=(phi-phi1)*(scale/scaleph)+minga;
semilogx(w1,phic,'Color',colp,'LineStyle','-.'), axis(YY)
%
if nargout==0
 if ~ih
  hold off, disp(' ')
 end
 figure(gcf), return
end
out1=phi1; out2=phi2;
if nargout==5
 out3=mag; out4=phi; out5=w1;
end
% --- last line of boded ---
