function [out1,out2,out3,out4,out5]=bodec(z,p,gain,arg4,arg5,arg6,arg7,arg8,arg9)
%BODEC	  Bode semilog plots in one figure (continuous-time systems).
%   BODEC(z,p,k,[col]) provides Bode semilog plots of the frequency response
%   function of the continuous-time system (z,p,k) with automatic scaling.
%   BODEC(z,p,k,om1,om2,[col]) provides Bode plots of the frequency response
%   function in the range om1 <= omega <= om2.
%   Parameter col (optional) defines color of plot; col must be a string
%   variable ('g'=green, 'b'=blue, 'r'=red, 'y'=yellow, 'c'=cyan,
%   'm'=magenta); default is col='g'.
%   External definition of axes is possible with "axis([xm,xM,ym,yM])".
%   Other uses:  [pho1,pho2]=BODEC(z,p,k,[col])
%		 [pho1,pho2]=BODEC(z,p,k,om1,om2,[col])
%		 [pho1,pho2]=BODEC(z,p,k,om1,om2,[col,phi1,phi2])
%   where [pho1,pho2] and [phi1 phi2] are optional outputs to exchange
%   information on phase scaling for a possible second call.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

%   A finite delay to can be specified with the 5-, 7- and 9- argument calls:
%   bodec(z,p,k,col,to), bodec(z,p,k,om1,om2,col,to),
%   bodec(z,p,k,om1,om2,col,phi1,phi2,to).

global HALEG

nargs=nargin; to=0;
error(nargchk(3,9,nargs));
if nargs==3
 col='g-'; col1='g-.';
elseif nargs==4
 col=[arg4,'-']; col1=[arg4,'-.'];
elseif nargs==5
 if isstr(arg4)
  to=arg5; col=[arg4,'-']; col1=[arg4,'-.'];
 else
  col='g-'; col1='g-.'; om1=arg4; om2=arg5;
 end
else  % (nargs==6)|(nargs==7)|(nargs==8)|(nargs==9)
 om1=arg4; om2=arg5; col=[arg6,'-']; col1=[arg6,'-.'];
 if nargs==7, to=arg7; end
 if nargs==9, to=arg9; end
end
flge=1;
if (nargs==8)|(nargs==9)
 if arg7<arg8
  phi1=arg7; phi2=arg8; flge=0;
 else
  phi1=arg8; phi2=arg7;
 end
 flgd=1;
else
 flgd=0;
end
%
[colp,colm,sty]=coltbl(col);
[tp1,tp2,tp3,tp4]=coltbl; colk=tp1(8,:);
nz=length(z); np=length(p);
%
ih=ishold; YY=axis; s1=get(gca,'XLimMode');
if ih | strcmp(s1,'manual')
 om1=YY(1); om2=YY(2);
else
 if (nargs==3)|(nargs==4)|((nargs==5)&isstr(arg4))
% automatic scaling
  tol=10^(-4);
  vv=abs([z;p]); vv=vv(find(vv>tol)); vv=log10(vv);
  if isempty(vv)
   om1=.01; om2=100;
  else
   om1=10^(floor(min(vv)-1)); om2=10^(ceil(max(vv)+1));
  end
 end
end
%
k1=log10(om1); k2=log10(om2);
j=sqrt(-1); nw=201; w=j*ones(1,nw); w1=logspace(k1,k2,nw)+eps;
w=j*w1; y=gain*ones(1,nw);
for kk=1:np
 y=y./(w-p(kk));
end
for kk=1:nz
 y=y.*(w-z(kk));
end
mag=abs(y)'; phi=(unwrap(angle(y))*180/pi)';
%
%  correction for phase
%
[gg,pp]=asymph(z,p,gain,w1(1),w1(nw));
kk=0;
while (abs(phi(1)-pp(1)) > 180) & (kk <= 12)
 kk=kk+1; phi=phi-360*sign(phi(1)-pp(1));
end
% correction for unwrap
for kk=1:np
 if (p(kk)~=0)&(abs(real(p(kk)))<eps)
  ii=find(w1>abs(imag(p(kk))));
  [gg,pp]=asymph(z,p,gain,w1(ii(1)),w1(ii(1)));
  if abs(phi(ii(1))-pp(1)) > 90
   phi(ii)=phi(ii)-180*sign(phi(ii(1))-pp(1));
  end
 end
end
for kk=1:nz
 if (z(kk)~=0)&(abs(real(z(kk)))<eps)
  ii=find(w1>abs(imag(z(kk))));
  [gg,pp]=asymph(z,p,gain,w1(ii(1)),w1(ii(1)));
  if abs(phi(ii(1))-pp(1)) > 90
   phi(ii)=phi(ii)-180*sign(phi(ii(1))-pp(1));
  end
 end
end
if to~=0, phi=phi-(180/pi)*w1'*to; end
%
mag1=20*log10(mag);
ha=semilogx(w1,mag1,w1(1),-20,w1(1),20);
set(ha(1),'Color',colp,'LineStyle','-')
set(ha(2),'Color',colk,'LineStyle','none','Marker','.')
set(ha(3),'Color',colk,'LineStyle','none','Marker','.')
HALEG=[HALEG,ha(1)];
%
if ih
 axis(YY)
else
 if strcmp(s1,'manual')
  minga=YY(3); maxga=YY(4);
 else
  minga=min(mag1); maxga=max(mag1);
 end
 if maxga < (minga+240)
  if (maxga-minga)<20, minga=minga-20; maxga=maxga+20; end
  yym=20*floor(minga/20+10^(-4)); yyM=20*ceil(maxga/20-10^(-4));
  ytick=[yym:20:yyM];
 else
  yym=40*floor(minga/40); yyM=40*ceil(maxga/40);
  ytick=[yym:40:yyM];
 end
 set(gca,'ylim',[yym,yyM],'ytick',ytick);
end
title('diagrammi di Bode di ampiezza (-) e fase (-.)')
aat=setstr(32*ones(1,70));
aam=sprintf('ampiezza (db) e fase (gradi)');
mess=[aat(1:70-length(aam)),aam];
ylabel(mess), hold on
YY=axis; minga=YY(3); maxga=YY(4); scale=maxga-minga;
%
ytick=get(gca,'ytick'); ndiv=length(ytick)-1;
%
if ((nargs==3|nargs==4) & ~ih) | (nargs>4 & flge)
 if flgd==1
  minph=round(phi1); maxph=round(phi2);
 else
  minph=min(phi); maxph=max(phi);
 end
 minph=30*floor(minph/30+10^(-4)); maxph=30*ceil(maxph/30-10^(-4));
 if (maxph-minph)<=180, minstp=7.5; else, minstp=15; end
 divph=ceil((maxph-minph)/minstp);
 kk=1;
 while divph>ndiv
  kk=kk+1;
  divph=ceil((maxph-minph)/(minstp*kk));
 end
 sstep=minstp*kk; scaleph=ndiv*sstep; minph=maxph-scaleph;
 phi1=minph; phi2=maxph; stepga=scale/ndiv;
 xxt=10^(log10(YY(2))+.02*(log10(YY(2))-log10(YY(1))));
 text(xxt,minga,sprintf('%.5g',minph))
 for kk=1:ndiv
  text(xxt,minga+kk*stepga,sprintf('%.5g',minph+kk*sstep))
 end
 aat=setstr(32*ones(1,120)); aam=sprintf('rad/sec');
 mess=[aat(1:120-length(aam)),aam]; xlabel(mess)
end
%
scaleph=phi2-phi1; phic=(phi-phi1)*(scale/scaleph)+minga;
semilogx(w1,phic,'Color',colp,'LineStyle','-.'), axis(YY)
%
if nargout==0
 if ~ih
  hold off, disp(' ')
 end
 figure(gcf), return
end
out1=phi1; out2=phi2;
if nargout==5
 out3=mag; out4=phi; out5=w1;
end
% --- last line of bodec ---
