function [om,ph]=asymph(z,p,K,om1,om2);
%ASYMPH   Asymptotic approximation of frequency response (phase).
%   [om,ph]=ASYMPH(z,p,k,om1,om2) provides frequency and phase angle points
%   to draw the asymptotic approximation of the frequency response of the
%   SISO system (z,p,k) in the angular frequency range (om1,om2).

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(5,5,nargs));
%
tol=10^(-8);
ii=find(abs(z)>tol);
nz0=length(z)-length(ii); % number of zeros at the origin
z1=z(ii);
ii=find(abs(p)>tol);
np0=length(p)-length(ii); % number of poles at the origin
p1=p(ii);
kga=real(K*prod(-z1)/prod(-p1));
dz1=[]; dz2=[]; dp1=[]; dp2=[];
lz1=length(z1);
for kk=1:lz1
 if abs(imag(z1(kk))) > tol*abs(real(z1(kk)))
  deltr=-real(z1(kk))/abs(z1(kk));
 else
  deltr=-sign(real(z1(kk)));
 end
 ratio=exp(pi*abs(deltr)/2);
 if deltr>0
  dz1=[dz1;abs(z1(kk))/ratio]; dz2=[dz2;abs(z1(kk))*ratio];
 elseif deltr<0
  dp1=[dp1;abs(z1(kk))/ratio]; dp2=[dp2;abs(z1(kk))*ratio];
 else
  dz1=[dz1;abs(z1(kk))-tol]; dz2=[dz2;abs(z1(kk))+tol];
 end
end
lp1=length(p1);
for kk=1:lp1
 if abs(imag(p1(kk))) > tol*abs(real(p1(kk)))
  deltr=-real(p1(kk))/abs(p1(kk));
 else
  deltr=-sign(real(p1(kk)));
 end
 ratio=exp(pi*abs(deltr)/2);
 if deltr>0
  dp1=[dp1;abs(p1(kk))/ratio]; dp2=[dp2;abs(p1(kk))*ratio];
 elseif deltr<0
  dz1=[dz1;abs(p1(kk))/ratio]; dz2=[dz2;abs(p1(kk))*ratio];
 else
  dp1=[dp1;abs(p1(kk))-tol]; dp2=[dp2;abs(p1(kk))+tol];
 end
end
%
azp=[dz1;dz2;dp1;dp2]; azp=azp(find(azp>om1)); azp=azp(find(azp<om2));
om=sort([om1;azp;om2]);
logfr=log10(om);
lfr=length(logfr);
dz1=log10(dz1); dz2=log10(dz2);
dp1=log10(dp1); dp2=log10(dp2);
ph=zeros(lfr,1);
if sign(kga)<0; ddph=-pi; else; ddph=0; end;
for kk=1:lfr
 ph(kk)=(-pi/2)*(np0-nz0)+ddph;
 for k1=1:length(dp1)
  ddd=dp2(k1)-dp1(k1);
  if logfr(kk)>=dp1(k1)
   if logfr(kk)<=dp2(k1)
    dist=logfr(kk)-dp1(k1);
    ph(kk)=ph(kk)-(pi/2)*dist/ddd;
   else
    ph(kk)=ph(kk)-pi/2;
   end
  end
 end
 for k1=1:length(dz1)
  ddd=dz2(k1)-dz1(k1);
  if logfr(kk)>=dz1(k1)
   if logfr(kk)<=dz2(k1)
    dist=logfr(kk)-dz1(k1);
    ph(kk)=ph(kk)+(pi/2)*dist/ddd;
   else
    ph(kk)=ph(kk)+pi/2;
   end
  end
 end
end
ph=(180/pi)*ph;
% --- last line of asymph ---
