function [om,y]=asymga(z,p,K,om1,om2);
%ASYMGA   Asymptotic approximation of frequency response (gain).
%   [om,y]=ASYMGA(z,p,k,om1,om2) provides frequency and magnitude points
%   to draw the asymptotic approximation of the frequency response of the
%   SISO system (z,p,k) in the angular frequency range (om1,om2).

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(5,5,nargs));
%
tol=10^(-8);
ii=find(abs(z)>tol);
nz0=length(z)-length(ii); % number of zeros at the origin
z1=z(ii);
ii=find(abs(p)>tol);
np0=length(p)-length(ii); % number of poles at the origin
p1=p(ii);
az1=abs(z1); ap1=abs(p1);
K=K*prod(az1)/prod(ap1);
azp=[az1;ap1]; azp=azp(find(azp>om1)); azp=azp(find(azp<om2));
om=sort([om1;azp;om2]);
logfr=log10(om); lfr=length(logfr);
tt=(logfr(lfr)-logfr(1))/1000;
ii=ones(1,lfr);
for kk=1:lfr-1
 if (logfr(kk+1)-logfr(kk)) < tt
  ii(kk)=0;
 end
end
logfr=logfr(find(ii));
om=om(find(ii));
lfr=length(logfr);
az1=log10(az1); ap1=log10(ap1);
y=zeros(lfr,1);
lK=log10(abs(K));
for kk=1:lfr
 y(kk)=lK+(np0-nz0)*(-logfr(kk));
 for k1=1:length(ap1)
  dist=(logfr(kk)-ap1(k1));
  if dist>0
   y(kk)=y(kk)+(-dist);
  end
 end
 for k1=1:length(az1)
  dist=(logfr(kk)-az1(k1));
  if dist>0
   y(kk)=y(kk)+dist;
  end
 end
end
y=exp(y*log(10));
% --- last line of asymga ---
