function [out1,out2]=arrowl(x0,y0,x,y,rx,ry,col,arg8);
%ARROWL   Arrow in plots for some TFI applications.
%   arrowl(x0,y0,x,y,rx,ry,col) draws an arrow with direction (x-x0),(y-y0).
%   Parameters rx,ry give the lengths of the arrow along axes, measured in
%   the current scales; col (string) is the color.
%   If called with 8 arguments, the arrow angle is set equal to pi.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

[col1,tp1,tp2]=coltbl(col);
phi=pi/6; if nargin==8; phi=pi/2; end
dx=(x-x0)/rx; dy=(y-y0)/ry;
dxy=sqrt(dx^2+dy^2);
fx=-dx/dxy; fy=-dy/dxy;
rotpiu=[rx,0;0,ry]*[cos(phi),-sin(phi);sin(phi),cos(phi)]*[fx,fy]';
rotmeno=[rx,0;0,ry]*[cos(phi),sin(phi);-sin(phi),cos(phi)]*[fx,fy]';
ha1=plot([x,x+rotpiu(1)],[y,y+rotpiu(2)]);
set(ha1,'Color',col1,'LineStyle','-')
ha2=plot([x,x+rotmeno(1)],[y,y+rotmeno(2)]);
set(ha2,'Color',col1,'LineStyle','-')
if nargout==0, return, end
out1=ha1; out2=ha2;
% --- last line of arrowl ---
