%
%
%       VPPC09_POG_epicicloidale_modello.m
%
%

clear all
close all
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE UNITA' DI MISURA DEL SISTEMA INTERNAZIONALE (SI)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
metri = 1; dm = 0.1*metri; cm = 0.01*metri; mm = 0.001*metri; km = 1000*metri;
kg = 1;
N = 1;
kN = 1000*N;
secondo = 1; ora = 60*60*secondo;  minuti = 60*secondo;
ms = 0.001*secondo;
Pa = 1;
rad = 1;
gradi =( pi/180)*rad;
bar = 10^5*Pa;
lt = 0.001*metri^3;
rpm = 2*pi/60*rad/secondo;
g = 9.8*metri/secondo^2;
Volt=1; Amp=1; Ohm=Volt/Amp;
Henry=Volt*secondo/Amp; Weber=Volt*secondo;
Si=true; Yes=true; No=false;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% DEFINIZIONE E COMPOSIZIONE DEL SISTEMA %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if Si

    syms u_i u_u y_i y_u

    syms J_s b_s r_s w_s Tau_s

    Sys.L=J_s;
    Sys.mA=-b_s;      % mA sottolinea che deve essere considerato anche il meno
    Sys.B=[1 r_s];
    Sys.C=[1; r_s];
    Sys.D=[0 0; 0 0];
    Sys.X=w_s;
    Sys.U=[Tau_s; u_u];
    Sys.Y=[w_s; y_u];
    Sys1=Sys;

    syms K_sc d_sc F_sc
    
%    d_sc=0;

    Sys.L=1/K_sc;
    Sys.mA=0;
    Sys.B=[1  1];
    Sys.C=[1; 1];
    Sys.D=[d_sc d_sc; d_sc d_sc];
    Sys.X=F_sc;
    Sys.U=[u_i; u_u];
    Sys.Y=[y_i; y_u];
    Sys2=Sys;

    W=1;
    Verifica_Sys(Sys1);
    Verifica_Sys(Sys2);
    Sys1=Componi_Tagliaferri(Sys1,Sys2,[y_u],[u_i],W);

    % Compongo i due sistemi attraverso la
    % funzione componi la quale necessita
    % dei due sistemi e del blocco W.

    syms J_p J_c b_p b_c r_p r_r w_p w_c Tau_c

    Sys.L=diag([J_p J_c]);
    Sys.mA=-diag([b_p b_c]);
    Sys.B=[-r_p r_p; 
            r_s r_r];
    Sys.C=[-r_p r_s; 
            r_p r_r ];
    Sys.D=[0 0; 0 0];
    Sys.X=[w_p; w_c];
    Sys.U=[u_i; u_u];
    Sys.Y=[y_i; y_u];
    Sys2=Sys;

    W=1;                                 % Il blocco W e' bidimensionale
    Sys1=Componi_Tagliaferri(Sys1,Sys2,[y_u],[u_i],W);

    syms K_cr d_cr F_cr

%    d_cr=0;

    Sys.L=1/K_cr;
    Sys.mA=0;
    Sys.B=[1  1];
    Sys.C=[1; 1];
    Sys.D=[d_cr d_cr; d_cr d_cr];
    Sys.X=F_cr;
    Sys.U=[u_i; u_u];
    Sys.Y=[y_i; y_u];
    Sys2=Sys;

    W=1;
    Sys1=Componi_Tagliaferri(Sys1,Sys2,[y_u],[u_i],W);

    syms J_r  b_r  w_r  Tau_r
    
    Sys.L=J_r;
    Sys.mA=-b_r;
    Sys.B=[r_r 1];
    Sys.C=[r_r; 1];
    Sys.D=[0 0; 0 0];
    Sys.X=w_r;
    Sys.U=[u_i;Tau_r];
    Sys.Y=[y_i;w_r];
    Sys2=Sys;

    W=1;
    SysA=Componi_Tagliaferri(Sys1,Sys2,[y_u],[u_i],W);
    % Show_Sys(SysA)

    SysB=Aggiungi_Ingresso_Sys(SysA,w_c,2,Tau_c,w_c); 
    
    disp('*********************************************')
    disp('Sistema completo SysB')
    disp('*********************************************')
    Show_Sys(SysB)                                
    % Inserire il sistema, la variabile di stato su
    % cui si vuole agire, il punto in cui inserire il
    % nuovo ingresso, il nuovo  ingresso e corrispondente uscita.

    
    T1=[1 0 0 0 0 0;
        0 0 0 0 0 1;
        0 0 1 0 0 0;
        0 1 0 0 0 0;
        0 0 0 0 1 0;
        0 0 0 1 0 0]

    SysC=Trasforma_Sys(SysB,T1);
    
    disp('*********************************************')
    disp('Sistema SysC: le elasticita all ultimo posto')
    disp('*********************************************')
    Show_Sys(SysC)
%
    B1=SysC.B([1 2],:)
    B2=SysC.B([3 4],:)
    B3=SysC.B([5 6],:)
    A11=SysC.mA([1 2],[1 2])
    A12=SysC.mA([1 2],[3 4])
    A13=SysC.mA([1 2],[5 6])
    A21=SysC.mA([3 4],[1 2])
    A22=SysC.mA([3 4],[3 4])
    A23=SysC.mA([3 4],[5 6])
    A31=SysC.mA([5 6],[1 2])
    A32=SysC.mA([5 6],[3 4])
    A33=SysC.mA([5 6],[5 6])
    %-inv(A32)*A31
    
    T2=[1 0 ;
        0 1 ;
        -r_s/r_p  r_s/r_p ;
        -r_s/r_r  1+r_s/r_r ;
        0 0 ;
        0 0 ]
    SysD=Trasforma_Sys(SysC,T2);

    disp('*********************************************')
    disp('Sistema SysD: le elasticita sono state mandate all'' infinito')
    disp('*********************************************')
    SysD.L=expand(SysD.L);
    SysD.mA=expand(SysD.mA);
    Show_Sys(SysD)

    disp('*********************************************')
    disp('Sistema SysDR: le elasticita sono state mandate all'' infinito usando Riduci()')
    disp('*********************************************')

    Parametri=[1/K_sc 1/K_cr];             % Elementi che voglio mandare a zero
    Variabili=[w_s w_c];                    % Variabili che cerco di salvare
    [SysDR TE1 Tu  TKx TKu]=Riduci_generale(SysB,Parametri,Variabili);
    SysDR.L=expand(SysDR.L);
    SysDR.mA=expand(SysDR.mA);
    Show_Sys(SysDR)
    
    disp('*********************************************')
    disp('Sistema SysDRJ0: tutto statico passando dal massivo')
    disp('*********************************************')

    Parametri=[J_s J_c J_p J_r];               % Elementi che voglio mandare a zero
    Variabili=[ ];                    % Variabili che cerco di salvare
    [SysDRJ0 TE1 Tu  TKx TKu]=Riduci_generale(SysDR,Parametri,Variabili);
    SysDRJ0.D=simplify(SysDRJ0.D);
    Show_Sys(SysDRJ0)
    simplify(SysDRJ0.D+SysDR.B.'*inv(SysDR.mA)*SysDR.B)
    simplify(inv(SysDR.mA))
    simplify(det(SysDRJ0.D))

    disp('*********************************************')
    disp('Sistema SysRtau: le inerzie Js Jc Jr sono state mandate zero')
    disp('*********************************************')

    Parametri=[J_s J_c J_r];               % Elementi che voglio mandare a zero
    Variabili=[F_sc w_p F_cr];                  % Variabili che cerco di salvare
    [SysRtau TE1 Tu  TKx TKu]=Riduci_generale(SysB,Parametri,Variabili);
    Show_Sys(SysRtau)

    disp('*********************************************')
    disp('Sistema SysRw: inversione ingressi-uscite  ')
    disp('*********************************************')
    
    [SysRw inv_S_N]=Inverti_Sys(SysRtau,[Tau_c Tau_r]);
    % Show_Sys(SysRw)
    [SysRw inv_S_N]=Inverti_Sys(SysRw,[Tau_s]);
    Show_Sys(SysRw)
    
% %     disp('*********************************************')
% %     disp('Sistema SysRwK0: tutto statico passando dal modello elastico')
% %     disp('*********************************************')
% % 
% %     Parametri=[1/K_sc J_p 1/K_cr];               % Elementi che voglio mandare a zero
% %     Variabili=[ ];                    % Variabili che cerco di salvare
% %     [SysRwK0 TE1 Tu  TKx TKu]=Riduci_generale(SysRw,Parametri,Variabili);
% %     SysRwK0.D=simplify(SysRwK0.D);
% %     Show_Sys(SysRwK0)
% %     simplify(SysRwK0.D-SysRw.D+SysRw.C*inv(SysRw.mA)*SysRw.B)
% %     simplify(det(SysRwK0.D))

   
    disp('*********************************************')
    disp('Sistema SysKscr: rimangono solo le elesticita ')
    disp('*********************************************')

    Parametri=[J_p];                            % Elementi che voglio mandare a zero
    Variabili=[F_sc F_cr];                      % Variabili che cerco di salvare
    [SysKscr TE1 Tu  TKx TKu]=Riduci_generale(SysRw,Parametri,Variabili);
    Show_Sys(SysKscr)
    
    disp('*********************************************')
    disp('Sistema SysKscr0: si pone [d_sc d_cr]=[0 0] ')
    disp('*********************************************')

    SysKscr0=Sostituisci_Sys(SysKscr,[d_sc d_cr], [0 0]);
    Show_Sys(SysKscr0)

    disp('*********************************************')
    disp('Sistema completo SysB con la variabile Fcr cambiata di segno')
    disp('*********************************************')
    [SysTmF TmF]=Cambia_Segno_X_Sys(SysB,[F_cr]);
    Show_Sys(SysTmF)

    
    disp('*********************************************')
    disp('Trasformazioni di coordinate T3 ')
    disp('*********************************************')
    
    T3=[0 0 0 1 0 0;
        1 0 0 0 0 0;
        0 1 0 0 0 0;
        0 0 0 0 1 0;
        0 0 1 0 0 0;
        0 0 0 0 0 1]

    SysT3=Trasforma_Sys(SysB,T3);
    
    disp('*********************************************')
    disp('Sistema SysT3: le velocit all''ultimo posto')
    disp('*********************************************')
    Show_Sys(SysT3)
%
    B1=SysT3.B([1 2 3],:)
    B2=SysT3.B([4 5 6],:)
    A11=SysT3.mA([1 2 3],[1 2 3])
    A12=SysT3.mA([1 2 3],[4 5 6])
    A21=SysT3.mA([4 5 6],[1 2 3])
    A22=SysT3.mA([4 5 6],[4 5 6])
    %-inv(A32)*A31
    
%     T2=[1 0 ;
%         0 1 ;
%         -r_s/r_p  r_s/r_p ;
%         -r_s/r_r  1+r_s/r_r ;
%         0 0 ;
%         0 0 ]
%     SysD=Trasforma_Sys(SysC,T2);
% 
%     disp('*********************************************')
%     disp('Sistema SysD: le elasticita sono state mandate all'' infinito')
%     disp('*********************************************')
%     SysD.L=expand(SysD.L);
    
%     NA=null(SysRw.mA);
%     NB=null(SysRw.B);
%     k3=null([NA.'; NB.';]);
%     x0=simplify(-inv(k3.'*SysRw.mA*k3)*k3.'*SysRw.B);
%     Dte=SysRw.C*k3*x0+SysRw.D
%     simplify(det(Dte))
% 
%     solve('-r_p*al=r_p','-b_p-r_p^2*d_sc-r_p^2*d_cr =-r_p*2','-r_p*ga=r_p','al,ga')
%     
%     solve(-SysRw.mA*x=k3)

% %     xx=simplify(SysRw.B*[r_s;-r_s-r_r;r_r]);
% %     Ax=[-SysRw.mA xx]
% %     rank(Ax)
% %     kort=[r_r 1; 0 1; -r_s 1];
% %     simplify([-1 0 1]*SysRw.B*[-2*r_r-r_s 1; r_r-r_s 1; 2*r_s+r_r 1])
% %     simplify(SysRw.B*[-2*r_r-r_s ; r_r-r_s ; 2*r_s+r_r ]/(-3*r_s*r_r))
      kc=null(SysRw.C)

      ka=null(SysRw.mA)
      kaT=null(SysRw.mA.')
      Gx=[0 1; 
          1 0; 
          0 1]
      Gx.'*ka
      %
      kb=null(SysRw.B)
      kbT=null(SysRw.B.')
      k1=[ r_s;
          -r_s-r_r;
          r_r]
      Gb=[ r_r 1; 
           0   1; 
          -r_s 1]
      Gb.'*k1
      det([SysRw.B*k1 Gx])
      rank([SysRw.B*k1 Gx])
      
      simplify(inv(-Gx.'*SysRw.mA*Gx))
      simplify(Gx.'*SysRw.B*Gb)
      simplify(inv(-Gx.'*SysRw.mA*Gx)*Gx.'*SysRw.B*Gb)
      simplify(inv(-Gx.'*SysRw.mA*Gx)*Gx.'*SysRw.B)
      D2=simplify(SysRw.C*Gx*inv(-Gx.'*SysRw.mA*Gx)*Gx.'*SysRw.B+SysRw.D)
      simplify(det(D2))
      


    return
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%% RIDUZIONE DEL SISTEMA %%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    Parametri=[1/K_cs 1/K_sr];             % Elementi che voglio mandare a zero
    Variabili=[w_c w_sc];                  % Variabili che cerco di salvare
    [SysR1 T1]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
    Show_Sys(SysR1)
    T1

    Variabili=[w_sc w_r];                 % Variabili che cerco di salvare
    [SysR2 T2]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
    Show_Sys(SysR2)
    T2

    Variabili=[w_c w_r];                   % Variabili che cerco di salvare
    [SysR3 T3]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
    Show_Sys(SysR3)
    T3

    Sys1=SysR1;
    % Rtras=cross(Sys1.B(1,:),Sys1.B(2,:));
    % Rap_Tras=double(subs(Rtras(2)/Rtras(1)));     % Rapporto di trasmissione

    Sys1.L=vpa(subs(Sys1.L),50);
    Sys1.mA=vpa(subs(Sys1.mA),50);
    Sys1.B=vpa(subs(Sys1.B),50);
    Sys1.C=vpa(subs(Sys1.C),50);           % Sostituzioni simboliche
    Sys1.D=vpa(subs(Sys1.D),50);
    Sys1.Y=vpa(subs(Sys1.Y));

    Show_Sys(Sys1)

    Sys2=SysR2;

    Sys2.L=vpa(subs(Sys2.L),50);
    Sys2.mA=vpa(subs(Sys2.mA),50);
    Sys2.B=vpa(subs(Sys2.B),50);
    Sys2.C=vpa(subs(Sys2.C),50);           % Sostituzioni simboliche
    Sys2.D=vpa(subs(Sys2.D),50);
    Sys2.Y=vpa(subs(Sys2.Y));

    Show_Sys(Sys2)

    Sys3=SysR3;

    Sys3.L=vpa(subs(Sys3.L),50);
    Sys3.mA=vpa(subs(Sys3.mA),50);
    Sys3.B=vpa(subs(Sys3.B),50);
    Sys3.C=vpa(subs(Sys3.C),50);           % Sostituzioni simboliche
    Sys3.D=vpa(subs(Sys3.D),50);
    Sys3.Y=vpa(subs(Sys3.Y));

    Show_Sys(Sys3)


end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%  DEFINIZIONE DEI PARAMETRI EPICICLOIDALE  %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
