%function [SysT]=Ultima_Trasformazione(Sys,n,rho,vett1,vett2)

%Questa funzione ha il compito di applicare al sistema Sys l'ultima
%trasformazione T_g che permette di esprimere le componenti del vettore di
%stato (vett2), che normalmente perderei, in funzione delle componenti del
%vettore di stato (vett1) che sono quelle che rimangono.
%Alla funzione vengono passati il sistema Sys da ridurre, la dimensione
%dinamica (n) del sistema, il numero di elementi dinamici (rho) che sono stati
%annullati, la dimensione  (vett1) del vettore che rimane, la dimensione
%(vett2) del vettore che si vuole esprimere in funzione di vett1
%La funzione resistuisce il sistema ridotto SysT che avr la dimensione 
%dinamica di vett1.
%

function [SysT]=Ultima_Trasformazione(Sys,n,rho,vett1,vett2)
    

c_A12=Sys.mA([1:vett1],[n-rho-vett2+1:n-rho]);
c_A22=Sys.mA([n-rho-vett2+1:n-rho],[n-rho-vett2+1:n-rho]);
c_B2=Sys.B([n-rho-vett2+1:n-rho],:);
c_C1=Sys.C(:,[1:vett1]);
c_C2=Sys.C(:,[size(Sys.C,2)-vett2+1:size(Sys.C,2)]);
T_g=[eye(vett1) -c_A12*inv(c_A22)];[zeros(vett2,vet1) eye(vett2)];

%Si applica la trasformazione per ottenere il sistema ridotto finale.

SysT.L= simplify(T_g*Sys.L);
SysT.X = Sys.X([1:vett1],:);
SysT.mA = simplify(T_g*Sys.mA);
SysT.B = simplify(T_g*Sys.B);
SysT.C=simplify(c_C1-c_C2*inv(c_A22)*c_A21);
SysT.D=simplify(Sys.D-c_C2*inv(c_A_22)*c_B2);
SysT.Y =Sys.Y;
SysT.U =Sys.U;

% Show_Sys(SysT)
return