% function SysT=Trasforma_Sys(Sys,T)
%
% Questa funzione applica le formule di riduzione al sistema "Sys"
% utilizzando della matrice "T".
%

function SysT=Trasforma_Sys(Sys,T)

ncT=size(T,2);                      % Numero colonne di T
nrT=size(T,1);                      % Numero righe di T

SysT.L=simplify(T.'*Sys.L*T);
SysT.mA=simplify(T.'*Sys.mA*T);
SysT.B=simplify(T.'*Sys.B);                   % Applico le formule di riduzione
SysT.C=simplify(Sys.C*T);
SysT.X=Sys.X(1:ncT);
for jj=[nrT:-1:1]
    ind_1=find(T(jj,:)==1);
    if length(ind_1)==1
        SysT.X(ind_1)=Sys.X(jj);    % E' una permutazione
    else
        eval(['syms x' num2str(jj)])    
        SysT.X(ind_1)=eval(['x' num2str(jj)]); % Creo un vettore di stato generico        
    end    
end

SysT.D=Sys.D;
SysT.U=Sys.U;                       % Questi 3 non subiscono trasformazioni
SysT.Y=Sys.Y;

return