% function SysT1=Separa_Sysv1(Sys,nr_in)
%
% Questa funzione separa le matrici B, C, D e i vettori U e Y nelle loro
% rispettive componenti [B1 B2], [C1; C2], [D11 D12; D21 D22], [U1;U2],
% [Y1; Y2]. 
% 

function SysT=Separa_Sysv1(Sys,nr_in)

ncB=size(Sys.B,2);             % Numero di colonne di B
ind_i=[1:nr_in];               % ind_i va dalla prima colonna a ncBi
ind_u=[nr_in+1:ncB];           % ind_u va da ind_i+1 all' ultima colonna 
SysT.L=Sys.L;
SysT.mA=Sys.mA;               % Questi 3 non subiscono separazioni
SysT.X=Sys.X;
SysT.B1=Sys.B(:,ind_i);
SysT.B2=Sys.B(:,ind_u);
SysT.C1=Sys.C(ind_i,:);
SysT.C2=Sys.C(ind_u,:);       % Scorporo le varie matrici\vettori
SysT.Y1=Sys.Y(ind_i,:);
SysT.Y2=Sys.Y(ind_u,:);
SysT.U1=Sys.U(ind_i,:);
SysT.U2=Sys.U(ind_u,:);
SysT.D11=Sys.D(ind_i,ind_i);
SysT.D12=Sys.D(ind_i,ind_u);
SysT.D21=Sys.D(ind_u,ind_i);
SysT.D22=Sys.D(ind_u,ind_u);

return