%function [SysT T Tu TKx TKu ]=Riduci_generale(Sys,Parametri,Variabili)
  
% Questa funzione riduce il sistema "Sys" di partenza in un nuovo sistema  
% "SysT" piu' semplice e compatto.
% La funzione riceve in ingresso il sistema da trasformare (Sys), i
% Parametri della matrice L che si vogliono annullare,le Dissipazioni della 
% matrice A che si vogliono annullare e le Variabili del vettore si stato 
% X che si vogliono mantenere.
% In uscita vengono restituite:la matrice di trasformazione T che
% permette di riottenere le prime variabili di stato che si eliminano, le
% matrici di trasformazione TKx e TKu che permettono di riottenere le
% ultime varibili di stato che si eliminano e la matrice di trasformazione
% Tu nel caso in cui una variabile di stato dipenda anche dall'ingresso.
%

function [SysT T Tu  TKx TKu]=Riduci_generale(Sys,Parametri,Variabili)

ncP=size(Parametri,2);
if ncP>1                        
    Parametri=Parametri.';       
end
                                % Controllo se sono vettori colonna,
ncV=size(Variabili,2);          %  se non lo sono li trasformo io.
if ncV>1
    Variabili=Variabili.';
end

% ncD=size(Dissipazioni,2);
% if ncD>1                        
%     Dissipazioni=Dissipazioni.';       
% end

nrP=length(Parametri);            % Dimensione del vettore Parametri
nrV=length(Variabili);            % Dimensione del vettore Variabili
%nrD=length(Dissipazioni);
n=size(Sys.X,1);                % Dimensione del vettore X quindi dimensione dinamica
                                 % del sistema

%A_w=simplify(Sys.mA-Sys.mA.')/2;     %Parte emisimmetrica della matrice Sys.mA

if Sys.L~=Sys.L.'
    disp('L non  simmetrica');   % Controllo se L e' simmetrica 
    return
end
for p=1:length(Parametri)
    if (ismember(diag(Sys.L),Parametri(p))==0)
        disp(['Warning: il parametro ' char(Parametri(p)) ' non  presente nella matrice L']);
    end
end
for p=1:length(Variabili)
    if (ismember(Sys.X,Variabili(p))==0)
        disp(['Warning: il parametro ' char(Variabili(p)) ' non  presente nel vettore di stato X']);
    end
end

% for p=1:length(Dissipazioni)
%    if (max(findstr(char(Sys.mA),char(Dissipazioni(p)))))~=0
%     else
%      disp(['Warning: il parametro ' char(Dissipazioni(p)) ' non  presente nella matrice A']);
%     end
% end
% p=0;
% jj=0;
% while p < length(Dissipazioni)
%     p=p+1;
%     jj=0;
%     if ((max(findstr(char(A_w),char(Dissipazioni(p)))))~=0) %controllo che l'elemento dissipativo appartenga alla parte simmetrica della matrice A
%      disp(['Warning: il parametro ' char(Dissipazioni(p)) ' non  una dissipazione e non pu essere annullato']);
%      park=Dissipazioni(nrD);            %Tramite queste istruzioni si spostano
%      Dissipazioni(nrD)=Dissipazioni(p);  %in fondo al vettore Dissipazioni i parametri
%      Dissipazioni(p)=park;                  %che non sono dissipazioni in modo da
%      jj=1;                              %eliminarli dal vettore Dissipazioni.
%      nrD=nrD-jj;
%      p=p-1;
%      Dissipazioni=Dissipazioni(1:nrD);   
%     end
% end

X0=zeros(n,1);
T=[];
for ii=[1:nrV]
    k=ismember(Sys.X,Variabili(ii));
    if (max(k)==1)                      % Costruisco la matrice T
      T=[T k];                          % e un vettore X0 con degli 1 
      X0=X0+k;                          % dove ho trovato le variabili.
    end
end
ind=find(X0==0);
En=eye(n);
T1=[T En(:,ind)] ;                      % Completo la matrice T con le  
                                        % colonne della matrice identita'
                                        % di indice corrispondente agli 0 
                                        % nel vettore X0.
                                          
SysA=Trasforma_Sys(Sys,T1);             % Applico le formule di riduzione
% Show_Sys(SysA) 

for ii=[1:nrP]
    if numden(Parametri(ii))==1
        new_el=1/Parametri(ii);         % Faccio il reciproco del parametro
        SysA.L=limit(SysA.L,new_el,inf);         % Faccio il limite per    
                                                 % new_el -> inf
    else
        SysA.L=limit(SysA.L,Parametri(ii),0);    % Faccio il limite per 
    end                                          % parametri -> 0
end

Ker=null(SysA.L);               % Cerco gli autovettori tali per cui L*Ker=0
disp('Numero di elementi annullati:');
rho=size(Ker,2)               % Numero di colonne della matrice Ker
X0=sum(Ker,2);                 % Costruisco la matrice T portando le
ind=find(X0==0);               % colonne di nome Ker alla fine per avere      
En=eye(n);                   % gli elementi che voglio azzerare in fondo 
T2=[En(:,ind) Ker];           % alle varie matrici.
                                         
SysA=Trasforma_Sys(SysA,T2);           % Applico le formule di riduzione

% for ii=[1:nrD]
%  SysA.mA=subs(SysA.mA,Dissipazioni(ii),0);      %Metto a zero gli elementi del                                       
%  SysA.B=subs(SysA.B,Dissipazioni(ii),0);      %vettore Dissipazione all'interno  
%  SysA.C=subs(SysA.C,Dissipazioni(ii),0);      %delle matrici del sistema  
%  SysA.D=subs(SysA.D,Dissipazioni(ii),0);      %
% end
disp('Sistema SysA:');
Show_Sys(SysA);
[rango_a_A_22 rango_unione]=Controllarango_Sys(SysA,rho);
disp('Rango matrice a_A22');
r=sym2poly(rango_a_A_22)  %per trasformare r da sym a int
disp('Rango matrice [a_A21 a_A22]');
r_u=sym2poly(rango_unione)
if (r_u)<rho
    disp('Errore: si vuole ridurre il sistema che appartiene a una casistica non contemplata');
    return
end    
if(r>0 && r<rho)
    [SysAt b_T34]= Annulla_colonne_dipendenti(SysA,rho,n);
end
% Show_Sys(SysAt)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%     
switch r
    case rho
        [SysT gen_A_22 gen_A_21  gen_B2 ]=Riduci_Sys_caso_I(SysA,rho,n);
        if(n==rho)
            TKx=0;
        else
            TKx=simplify([T1*T2*[zeros(n-rho,n-rho);-inv(gen_A_22)*gen_A_21]]);%Trasformazione che permette di riottenere
        end                                                         %le variabili di stato perse da quelle rimaste
        TKu=simplify([T1*T2*[zeros(n-rho,size(SysT.B,2));-inv(gen_A_22)*gen_B2]]);%Trasformazione che permette di riottenere
        T=0;                                                       %le variabili di stato perse dal vettore ingresso                        
        Tu=0;
    case 0
        [SysT T_rid b_T gen_A_22 gen_A_21  gen_B2]=Riduci_Sys_caso_II(SysA,rho,n);
        if(n==2*rho)
            TKx=0;
            TKu=simplify([T1*T2*[zeros(n-rho,size(SysT.U,1));-inv(gen_A_22)*gen_B2]]);%Trasformazione che permette
            % di ottenere il vettore a_x2 dal vettore di ingresso u.
            T=0;
        else
            TKx=simplify([T1*T2*b_T*[zeros(n-rho,n-2*rho);-inv(gen_A_22)*gen_A_21]]); 
            TKu=simplify([T1*T2*b_T*[zeros(n-rho,size(SysT.B,2));-inv(gen_A_22)*gen_B2]]);%Trasformazioni che permettono
            %di recuperare b_x3 dal vettore di stato e dal vettore di
            %ingresso
            T=T1*T2*b_T*T_rid; %trasformazione che mi permette di recuperare b_x2
        end
        Tu=0;
end
if (r~=0 && r~=rho)
    [SysT T_rid b_T c_T_u gen_A_22 gen_A_21  gen_B2]=Riduci_Sys_caso_III(SysAt,rho,n,r);
    if(n==2*rho-r)
        Tu=simplify(T1*T2*b_T34*b_T*[zeros(n-r,size(SysT.U,1));-gen_A_22*gen_B2]);%Trasformazione che permette
        %di ottenere il vettore b_x3 dal vettore degli ingressi u
        TKu=simplify(T1*T2*b_T34*b_T*[zeros(n-rho+r,size(c_T_u,2));c_T_u]);%Trasformazione che permette
        %di ottenere il vettore b_x4 dal vettore degli ingressi u
        T=0;
        TKx=0;
    else
        TKx=simplify([T1*T2*b_T34*b_T*[zeros(n-rho+r,n-2*rho+r);-inv(gen_A_22)*gen_A_21]]);
        TKu=simplify([T1*T2*b_T34*b_T*[zeros(n-rho+r,size(SysT.B,2));-inv(gen_A_22)*gen_B2]]);
        T=T1*T2*b_T34*b_T*T_rid;
        Tu=T1*T2*b_T34*b_T*c_T_u;
    end
end
return