function [SysT  T_rid b_T c_A_22 c_A_21  c_B2 ]=Riduci_Sys_caso_II(Sys,rho,n)

if (n==2*rho)%si annullano tutti gli elementi dinamici
    a_A12=Sys.mA([1:n-rho],[n-rho+1:n])  %in realt  a_A12
    c_A_21=0;
    a_B2=Sys.B([n-rho+1:n],:);
    a_B1=Sys.B([1:n-rho],:);            
    if a_B2~=0
        disp('Warning:a_B2 non  nulla. Viene messa a zero perch un ingresso non pu agire su un elemento nullo.');
    end
    SysT.L=0;
    SysT.X=0;
    SysT.mA=0;
    SysT.B=0;
    SysT.C=0;
    SysT.U=Sys.U;
    SysT.Y=Sys.Y;
    SysT.D=Sys.D;
    c_A_22=a_A12; %elementi passati per riottenere il vettore di stato a_x2
    c_B2=a_B1;
    b_T=0;
    T_rid=0;
    return    
end

rango=zeros(1,n+1);                   % Inizializzo il vettore rango
jj=n+1;                               % Parto una colonna dopo per 
                                      % entrare nel ciclo con rango=0.
while rango(jj)<rho
    jj=jj-1;                             % Calcolo il rango partendo
    P=Sys.mA([n-rho+1:n],[jj:n]);        % dall'ultima colonna fino a 
    rango(jj)=rank(P);                   % quando non arrivo a rho colonne  
end                                      % linearmente indipendenti tra le 
                                         % ultime rho righe. 
for jj=[1:n]                       %Con questo ciclo le componenti del
    if rango(jj)==rango(jj+1)+1;   %vettore rango relative alle colonne l.i
        rango(jj)=1;               %si pongono a 1 quelle delle colonne l.d
    else                           %si pongono a 0.
        rango(jj)=0;
    end
end

rango=rango(1:n);

ind1=find(rango(1:n-rho)==0);            % Cerco gli elementi del vettore 
nr_b_x1=length(ind1);                    % rango che sono nulli e non tra  
ind2=find(rango~=0);                   % la prima e la n-rho-esima 
ind3=find(rango(n-rho+1:n)==0);   % colonna, e quelli nulli dalla 
nr_b_x2=length(ind2);               % n-rho+1-esima all'ultima  
nr_b_x3=length(ind3);               % colonna per poter costruire...
En1=eye(n-rho);                   
b_T1=[En1(:,ind1)];
b_T2=[En1(:,ind2)];
En2=eye(rho);
b_T=[[b_T1 b_T2 zeros(n-rho,rho)];[zeros(rho,n-rho) En2] ]; 
%...la matrice b_T la quale  
% riordina le matrici in modo
% che si evidenzino:1) le componenti del vettore di
% stato che voglio mantenere (ind1);
%2)le componenti esprimibili in funzione di quelle
%che voglio mantenere (ind2)
%3)le componenti che perdo (ind3).
disp('Sistema SysB:');  
SysB=Trasforma_Sys(Sys,b_T);  
Show_Sys(SysB)
b_A_32=SysB.mA([n-rho+1:n],[nr_b_x1+1:n-nr_b_x3]); 
b_A_31=SysB.mA([n-rho+1:n],[1:nr_b_x1]);           
b_B3=SysB.B([n-rho+1:n],:);
if b_B3==0
else    
    disp('Warning:b_B3 non  nulla. Viene messa a zero la matrice e quindi ingressi che agiscono');
    disp('direttamente su quell`elemento');
    SysB.B([n-rho+1:n],[1:size(SysB.B,2)])=zeros(nr_b_x3,size(SysB.B,2)); %annullo b_B3
    SysB.C([1:size(SysB.C,1)],[n-rho+1:n])=zeros(size(SysB.C,1),nr_b_x3); %annullo b_C3
%     ind1=find(b_B3==1);%trovo quali colonne di e_B3 sono diverse da zero
%     indm1=find(b_B3==-1);
%     ind=[ind1 indm1];
%     for jj=[1:size(ind,2)]
%         SysB.B(:,ind(jj))=zeros(n,1); %annullo le rispettive colonne di b_B
%         SysB.C(ind(jj),:)=zeros(1,n); %annullo le rispettive colonne di b_C  
%         SysB.D(:,ind(jj))=zeros(size(SysB.B,2),1);%annullo le rispettive colonne di b_D
%     end    
end
%DetG=simplify(det(G));        %Calcolo determinante perch al suo interno
% AggG=simplify(DetG*inv(G)); %potrebbe avere un elemento tempo variante che andrebbe al denominatore
T_rid=simplify([eye(nr_b_x1);-inv(b_A_32)*b_A_31; zeros(rho,nr_b_x1)]); %Matrice di trasformazione       
                                                                    %che fa perdere le
                                                                     %componenti b_x3.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c_T=[T_rid [zeros(n-nr_b_x3,nr_b_x3);eye(nr_b_x3)]];  % trasformazione che permette
                                                          %di tenere b_x3
b_L1=SysB.L([1:nr_b_x1],[1:nr_b_x1]);
b_L2=SysB.L([nr_b_x1+1:nr_b_x1+nr_b_x2],[nr_b_x1+1:nr_b_x1+nr_b_x2]);
T_f=simplify([T_rid.';[b_A_31*inv(b_L1) b_A_32*inv(b_L2) eye(nr_b_x3)]]);
    
%Si applica la trasformazione
SysC.L=simplify(T_f*SysB.L*c_T);
SysC.X=[[eye(nr_b_x1) zeros(nr_b_x1,nr_b_x2+nr_b_x3)];[zeros(nr_b_x3,nr_b_x1+nr_b_x2) eye(nr_b_x3)]]*SysB.X;
SysC.mA=simplify(T_f*SysB.mA*c_T);
SysC.B=simplify(T_f*SysB.B);
SysC.C=simplify(SysB.C*c_T);
SysC.D=simplify(SysB.D);
SysC.U=SysB.U;
SysC.Y=SysB.Y;
disp('Sistema SysC:');
Show_Sys(SysC)
c_A_12=SysC.mA([1:nr_b_x1],[n-nr_b_x2-nr_b_x3+1 : n-nr_b_x2]);
c_A_22=SysC.mA([n-nr_b_x3-nr_b_x2+1:n-nr_b_x2],[n-nr_b_x3-nr_b_x2+1:n-nr_b_x2]);
c_A_21=SysC.mA([n-nr_b_x3-nr_b_x2+1:n-nr_b_x2],[1:nr_b_x1]);
c_B2=SysC.B([[n-nr_b_x3-nr_b_x2+1:n-nr_b_x2]],:);
rango_c_A_12=rank(c_A_12)
if(rango_c_A_12==0)                 %in questo caso non  necessario applicare l'ultima trasformazione
    SysT=Trasforma_Sys(SysB,T_rid);    % Applico le formule di riduzione
else
    disp(['Warning: trovato sistema con _a_A_22=0 per con c_A_21 diverso da zero']);
    [SysT]=Ultima_Trasformazione(SysC,n,rho,nr_b_x1,nr_b_x3)
end