%function [Sys]=Crea_Sys(nome_elem,nome_dissi,tipo_colle,nome_var,nome_ing,tipo_ing,nome_out,tipo_out,nome_ing_o,nome_out_o)
%
%Questa funzione crea automaticamente le matrici A B C D L e i vettori X U
%Y di un elemento dinamico qualunque.
%Alla funzione viene passato: 
%- nome_elem: il nome dell'elemento dinamico o della dissipazione, pu 
%             essere scelto dall'utente; 
%- nome_dissi: il nome dell'eventuale dissipazione connessa all'elemnto
%              dinamico, pu essere scelto dall'utente. 
%- tipo_colle: il tipo di elemento dinamico in formato stringa, 
%              il quale pu ricadere solo in uno di questi casi:   
%               - C: elemento dinamico tipo capacit, quindi pu essere una
%                    capacit elettrica o una capacit idraulica o una massa
%                    o un'inerzia;   
%               - L: elemento dinamico tipo induttanza, quindi pu essere una
%                    induttanza elettrica o un'induttanza idraulica o una
%                    molla o un'elasticit rotazionale;
%                
%               -RCserie: collegamento di un elemento tipo capacit con un 
%                         elemento dissipativo in serie;
%               -RCparallelo: collegamento di un elemento tipo capacit con un 
%                         elemento dissipativo in parallelo;
%               -RLserie: collegamento di un elemnto tipo iduttanza con un 
%                         elemento dissipativo in serie;
%               -RLparallelo: collegamento di un elemento tipo induttanza con un 
%                         elemento dissipativo in parallelo;
%               -RCparitore: collegamento di un elemento tipo condensatore
%                            con un elemento dissipativo nella modalit
%                            partitore di tensione;
%               -RLparitore: collegamento di un elemento tipo induttanza
%                            con un elemento dissipativo nella modalit
%                            partitore di tensione;
%- nome_var: nome della variabile di stato, a scelta dell'utente;
%- nome_ing: nome dell'ingresso, a scelta dell'utente;
%- tipo_ing: tipologia di variabile di ingresso in formato stringa, la quale 
%            pu ricadere solo in uno di questi casi e deve essere duale 
%             con l'uscita:
%               - Across;
%               - Through;
%- nome_out: nome dell'uscita a scelta dell'utente;
%- tipo_out: tipologia di variabile di uscita in formato stringa, la quale 
%            pu ricadere solo in uno di questi casi e deve essere duale 
%            con l'ingresso:
%               - Across;
%               - Through;
%-nome_ing_o: nome dell'ingresso alla porta di uscita,a scelta dell'utente;
%-nome_out_o: nome dell'uscita alla porta di uscita, a scelta
%               dell'utente;
%Con queste informazioni la funzione costruisce le matrici dell'elemento,
%con la convezione che siano presenti due porte energetiche, una in
%ingresso (nome_ing e nome_out) e una in uscita (nome_ing_o nome_out_o),
%attraverso le quali la potenza sia sempre entrante.
%La funzione restituisce il sistema dinamico creato (Sys) 

%

function [Sys]=Crea_Sys(nome_elem,nome_dissi,tipo_colle,nome_var,nome_ing,tipo_ing,nome_out,tipo_out,nome_ing_o,nome_out_o)




if strcmp(tipo_ing,tipo_out)==1
    disp('Errore: non si pu avere in ingresso ed in uscita da un elemento dianmico lo stesso tipo variabile');
    return
end    
if (strcmp(tipo_colle,'C')==1  && strcmp(tipo_ing,'Through')==1) || (strcmp(tipo_colle,'L')==1  && strcmp(tipo_ing,'Across')==1)
    Sys.L=nome_elem;
    Sys.A=0;
    Sys.B=[1 1];
    Sys.C=[1; 1];
    Sys.D=[0 0; 0 0];
    Sys.X=nome_var;
    Sys.U=[nome_ing; nome_ing_o];
    Sys.Y=[nome_out; nome_out_o];
    return
end    
if(strcmp(tipo_colle,'C')==1  && strcmp(tipo_ing,'Across')==1)|| (strcmp(tipo_colle,'L')==1  && strcmp(tipo_ing,'Through')==1)
   Sys.L=nome_elem;
   Sys.A=0;
   Sys.B=[1 -1];
   Sys.C=[0; -1];
   Sys.D=[0 -1; 1 0];
   Sys.X=nome_var;
   Sys.U=[nome_ing; nome_ing_o];
   Sys.Y=[nome_out; nome_out_o];
    return
end     
if strcmp(tipo_colle,'RCserie')==1 
   Sys.L=nome_elem;
   Sys.A=0;
   Sys.B=[1 0];
   Sys.C=[1; 0];
   Sys.D=[nome_dissi -1; 1 0];
   Sys.X=nome_var;
   Sys.U=[nome_ing; nome_ing_o];
   Sys.Y=[nome_out; nome_out_o];
   if strcmp(tipo_ing,'Across')==1
       [Sys inv_S_N]=Inverti_Sys(Sys,nome_ing,1) 
       Sys.U=[nome_ing;nome_ing_o]
       Sys.Y=[nome_out;nome_out_o]
   end
   return
end
if strcmp(tipo_colle,'RCparallelo')==1 && strcmp(tipo_ing,'Through')==1  
   Sys.L=nome_elem;
   Sys.A=inv(nome_dissi);
   Sys.B=[1 1];
   Sys.C=[1; 1];
   Sys.D=[0 0; 0 0];
   Sys.X=nome_var;
   Sys.U=[nome_ing; nome_ing_o];
   Sys.Y=[nome_out; nome_out_o];
   return
end
if strcmp(tipo_colle,'RLserie')==1 && strcmp(tipo_ing,'Across')==1  
   Sys.L=nome_elem;
   Sys.A=nome_dissi;
   Sys.B=[1 1];
   Sys.C=[1; 1];
   Sys.D=[0 0; 0 0];
   Sys.X=nome_var;
   Sys.U=[nome_ing; nome_ing_o];
   Sys.Y=[nome_out; nome_out_o];
   return
end
if strcmp(tipo_colle,'RLparallelo')==1   
   Sys.L=nome_elem;
   Sys.A=nome_dissi;
   Sys.B=[nome_dissi nome_dissi];
   Sys.C=[-nome_dissi; -nome_dissi];
   Sys.D=[nome_dissi nome_dissi; nome_dissi nome_dissi];
   Sys.X=nome_var;
   Sys.U=[nome_ing; nome_ing_o];
   Sys.Y=[nome_out; nome_out_o];
   if strcmp(tipo_ing,'Across')==1
       [Sys inv_S_N]=Inverti_Sys(Sys,nome_ing,1)
       Sys.U=[nome_ing;nome_ing_o]
       Sys.Y=[nome_out;nome_out_o]
   end
   return
end
if strcmp(tipo_colle,'RCpartitore')==1   
   Sys.L=nome_elem;
   Sys.A=0;
   Sys.B=[1 1];
   Sys.C=[1;1];
   Sys.D=[nome_dissi 0; 0 0];
   Sys.X=nome_var;
   Sys.U=[nome_ing; nome_ing_o];
   Sys.Y=[nome_out; nome_out_o];
   if strcmp(tipo_ing,'Across')==1
       [Sys inv_S_N]=Inverti_Sys(Sys,nome_ing,1)
       Sys.U=[nome_ing;nome_ing_o]
       Sys.Y=[nome_out;nome_out_o]
   end
   return
end
if strcmp(tipo_colle,'RLpartitore')==1   
   Sys.L=nome_elem;
   Sys.A=0;
   Sys.B=[0 1];
   Sys.C=[0; 1];
   Sys.D=[inv(nome_dissi) -inv(nome_dissi); -inv(nome_dissi) inv(nome_dissi)];
   Sys.X=nome_var;
   Sys.U=[nome_ing; nome_ing_o];
   Sys.Y=[nome_out; nome_out_o];
   if strcmp(tipo_ing,'Through')==1
       [Sys inv_S_N]=Inverti_Sys(Sys,nome_ing,1)
       Sys.U=[nome_ing;nome_ing_o]
       Sys.Y=[nome_out;nome_out_o]
   end
   return
end
disp('Errore:  impossibile creare il sistema inserito');