%function [Sys]=Crea2_Sys(nome_elem,tipo_elem,nome_var,nome_ing_i,tipo_ing_i,nome_out_i,tipo_out_i,nome_ing_o,tipo_ing_o,nome_out_o,tipo_out_o)
%
%Questa funzione crea automaticamente le matrici A B C D L e i vettori X U
%Y di un elemento dinamico qualunque.
%Alla funzione viene passato: 
%- nome_elem: il nome dell'elemento dinamico o della dissipazione, pu 
%             essere scelto dall'utente; 
%- tipo_elem: il tipo di elemento dinamico in formato stringa, 
%             il quale pu ricadere solo in uno di questi casi:   
%             - 'C': elemento dinamico tipo capacit, quindi pu essere una
%                    capacit elettrica o una capacit idraulica o una massa
%                    o un'inerzia;   
%            - 'L': elemento dinamico tipo induttanza, quindi pu essere una
%                    induttanza elettrica o un'induttanza idraulica o una
%                    molla o un'elasticit rotazionale;
%            - 'R': elemento dissipativo, quindi pu essere una resistenza 
%                  elettrica o una resistenza idraulica o un attrito.  
%- nome_var: nome della variabile di stato, a scelta dell'utente;
%- nome_x_y: nome della variabile a scelta dell'utente, x indica se
%            ingresso o uscita (ing out) la y se appartiene alla porta di
%            ingresso o a quella di uscita (i o);
%             
%- tipo_x_y,: tipologia di variabile di in formato stringa, la quale 
%            pu ricadere solo in uno di questi casi e deve essere duale 
%            con l'uscita:
%             - 'A':tipo Across;
%             - 'T':tipo Through;
%            x indica se ingresso o uscita (ing out) la y se appartiene 
%             alla porta di ingresso o a quella di uscita (i o);   
%Con queste informazioni la funzione costruisce le matrici dell'elemento,
%con la convezione che siano presenti due porte energetiche, una in
%ingresso (nome_ing e nome_out) e una in uscita (nome_ing_o nome_out_o),
%attraverso le quali la potenza sia sempre entrante.
%La funzione restituisce il sistema dinamico creato (Sys) 

%
function [Sys]=Crea2_Sys(nome_elem,tipo_elem,nome_var,nome_ing_i,tipo_ing_i,nome_out_i,tipo_out_i,nome_ing_o,tipo_ing_o,nome_out_o,tipo_out_o)

if strcmp(tipo_ing_i,tipo_out_i)==1 || strcmp(tipo_ing_o,tipo_out_o)==1 
    disp('Errore: non si pu avere in ingresso ed in uscita da un elemento dianmico lo stesso tipo variabile');
    return
end  

if (strcmp(tipo_elem,'C')==1  && strcmp(tipo_ing_i,'T')==1 && strcmp(tipo_ing_o,'A')==1 && strcmp(tipo_out_i,'A')==1 && strcmp(tipo_out_o,'T')==1) || (strcmp(tipo_elem,'L')==1  && strcmp(tipo_ing_i,'A')==1 && strcmp(tipo_ing_o,'T')==1 && strcmp(tipo_out_i,'T')==1 && strcmp(tipo_out_o,'A')==1)
    Sys.L=nome_elem;
    Sys.A=0;
    Sys.B=[1 0];
    Sys.C=[1; 0];
    Sys.D=[0 -1; 1 0];
    Sys.X=nome_var;
    Sys.U=[nome_ing_i; nome_ing_o];
    Sys.Y=[nome_out_i; nome_out_o];
    return
end    
if (strcmp(tipo_elem,'C')==1  && strcmp(tipo_ing_i,'A')==1 && strcmp(tipo_ing_o,'T')==1 && strcmp(tipo_out_i,'T')==1 && strcmp(tipo_out_o,'A')==1) || (strcmp(tipo_elem,'L')==1  && strcmp(tipo_ing_i,'T')==1 && strcmp(tipo_ing_o,'A')==1 && strcmp(tipo_out_i,'A')==1 && strcmp(tipo_out_o,'T')==1)
    Sys.L=nome_elem;
    Sys.A=0;
    Sys.B=[0 1];
    Sys.C=[0; -1];
    Sys.D=[0 1; 1 0];
    Sys.X=nome_var;
    Sys.U=[nome_ing_i; nome_ing_o];
    Sys.Y=[nome_out_i; nome_out_o];
    return
end   
if (strcmp(tipo_elem,'C')==1  && strcmp(tipo_ing_i,'T')==1 && strcmp(tipo_ing_o,'T')==1 && strcmp(tipo_out_i,'A')==1 && strcmp(tipo_out_o,'A')==1) || (strcmp(tipo_elem,'L')==1  && strcmp(tipo_ing_i,'A')==1 && strcmp(tipo_ing_o,'A')==1 && strcmp(tipo_out_i,'T')==1 && strcmp(tipo_out_o,'T')==1)
    Sys.L=nome_elem;
    Sys.A=0;
    Sys.B=[1 1];
    Sys.C=[1; 1];
    Sys.D=[0 0; 0 0];
    Sys.X=nome_var;
    Sys.U=[nome_ing_i; nome_ing_o];
    Sys.Y=[nome_out_i; nome_out_o];
    return
end   
if (strcmp(tipo_elem,'R')==1  && strcmp(tipo_ing_i,'A')==1 && strcmp(tipo_ing_o,'T')==1 && strcmp(tipo_out_i,'T')==1 && strcmp(tipo_out_o,'A')==1)
    Sys.L=0;
    Sys.A=0;
    Sys.B=[0 0];
    Sys.C=[0; 0];
    Sys.D=[0 1; -1 nome_elem];
    Sys.X=0;
    Sys.U=[nome_ing_i; nome_ing_o];
    Sys.Y=[nome_out_i; nome_out_o];
    return
end
if (strcmp(tipo_elem,'R')==1  && strcmp(tipo_ing_i,'T')==1 && strcmp(tipo_ing_o,'A')==1 && strcmp(tipo_out_i,'A')==1 && strcmp(tipo_out_o,'T')==1)
    Sys.L=0;
    Sys.A=0;
    Sys.B=[0 0];
    Sys.C=[0; 0];
    Sys.D=[nome_elem -1; 1 0];
    Sys.X=0;
    Sys.U=[nome_ing_i; nome_ing_o];
    Sys.Y=[nome_out_i; nome_out_o];
    return
end
if (strcmp(tipo_elem,'R')==1  && strcmp(tipo_ing_i,'A')==1 && strcmp(tipo_ing_o,'A')==1 && strcmp(tipo_out_i,'T')==1 && strcmp(tipo_out_o,'T')==1)
    Sys.L=0;
    Sys.A=0;
    Sys.B=[0 0];
    Sys.C=[0; 0];
    Sys.D=[1/nome_elem 1/nome_elem; 1/nome_elem 1/nome_elem];
    Sys.X=0;
    Sys.U=[nome_ing_i; nome_ing_o];
    Sys.Y=[nome_out_i; nome_out_o];
    return
end
if (strcmp(tipo_elem,'R')==1  && strcmp(tipo_ing_i,'T')==1 && strcmp(tipo_ing_o,'T')==1 && strcmp(tipo_out_i,'A')==1 && strcmp(tipo_out_o,'A')==1)
    Sys.L=0;
    Sys.A=0;
    Sys.B=[0 0];
    Sys.C=[0; 0];
    Sys.D=[-nome_elem -nome_elem; nome_elem nome_elem];
    Sys.X=0;
    Sys.U=[nome_ing_i; nome_ing_o];
    Sys.Y=[nome_out_i; nome_out_o];
    return
end
disp('Errore:  impossibile creare il sistema inserito');