% function SysT=Componi_Tagliaferri(Sys1,Sys2,elem1,elem2,W)
%
% Questa funzione compone i due sistemi Sys1 e Sys2 passati dall'utente.
% L'algoritmo necessita di sapere quali elementi (elem1) del primo sistema deve
% collegare con quali elementi (elem2) del secondo, siano essi uscite o
% ingressi. Nel caso si vogliano collegare due ingressi (caso=1) la funzione tenta di
% invertire il primo sistema, se non riesce prova con il secondo e se non
% riesce i sistemi non sono colllegabili in quel modo.
% La funzione implementa anche i casi in cui si vogliano collegare due
% uscite (caso=3) o un ingresso con un'uscita (caso=2 o caso=0).
% Viene inoltre dato il blocco di connessione W.
% La funzione restituisce il sistema composto SysT.
%

function [SysT]=Componi_Tagliaferri(Sys1,Sys2,elem1,elem2,W)

[nr_elem1 nc_elem1]=size(elem1);
if nc_elem1>nr_elem1                 % Se il numero di colonne  maggiore del 
    elem1=elem1.';                   % numero di righe si fa il trasposto
    [nr_elem1 nc_elem1]=size(elem1); % e si ricalcola il numero di righe e colonne
end

[nr_elem2 nc_elem2]=size(elem2);
if nc_elem2>nr_elem2
    elem2=elem2.';
    [nr_elem2 nc_elem2]=size(elem2);
end
if (nc_elem1>1)|(nc_elem2>1)|(nr_elem2~=nr_elem1)                 % Se non sono   
   disp('Errore: (nc_elem1>1)|(nc_elem2>1)|(nc_elem2~=nc_elem1)') % vettori di 1 sola    
   return                                               % colonna da errore
end
if (Xi_Tutti_Diversi(elem1)==0)|(Xi_Tutti_Diversi(elem2)==0)  % Se ci sono due 
   disp('Errore: Ci sono due elementi uguali in elem1 e/o in elem2')% elementi
   return                                        % ugali esco con un errore
end
caso=0;
for ii=[1:nr_elem1]
    k=ismember(Sys1.Y,elem1(ii));      
    h=ismember(Sys1.U,elem1(ii));
    l=ismember(Sys2.Y,elem2(ii));
    m=ismember(Sys2.U,elem2(ii));
    if (max(k)~=1 && max(h)~=1 && max(l)~=1 && max(m)~=1 )                    
        disp('Errore: elemento non presente ne sul vettore degli ingressi ne sul vettore delle uscite')
        return
    elseif (max(k)~=1 && max(h)==1 && max(l)~=1 && max(m)==1)
        caso=1 %si vuole collegare ing1 con ing2
    elseif (max(k)~=1 && max(h)==1 && max(l)==1 && max(m)~=1)
        caso=2 %si vuole collegare ing1 con out2
    elseif (max(k)==1 && max(h)~=1 && max(l)==1 && max(m)~=1)
        caso=3 %si vuole collegare out1 con out2
    end    
end
if caso==1
    [Sys1 inv_S_N]=Inverti_Sys(Sys1,elem1); %inverto il primo sistema
    if inv_S_N==0                             % Sys1 non invertibile 
        [Sys2 inv_S_N]=Inverti_Sys(Sys2,elem2);%inverto il secondo sistema
        if inv_S_N==0                          %Sys2 non invertibile 
            disp('Errore:Non si riesce a fare il collegamento perch i sistemi non sono  ivertibili');
            return
        end
        caso=2;
    end
end
if caso==3
    [Sys2 inv_S_N]=Inverti_Sys(Sys2,elem2);
    if inv_S_N==0
        [Sys1 inv_S_N]=Inverti_Sys(Sys1,elem1);
        if inv_S_N==0
            disp('Errore:Non si riesce a fare il collegamento perch i sistemi non sono  invertibili');
        end
        caso=2;
    end
end
if caso==2 %collego ing1 con out2
    nr_vett1=size(Sys1.U,1); %Gli ingressi da collegare vanno messi in fondo
    vett1=Sys1.U;            %al vettore degli ingressi
    nr_vett2=size(Sys2.Y,1); %Le uscite da collegare vanno messe in cima
    vett2=Sys2.Y;            %al vettore delle uscite   
else %collego out1 con ing2: caso normale
    nr_vett1=size(Sys1.Y,1);%Le uscite da collegare vanno messe in fondo
    vett1=Sys1.Y;           %al vettore delle uscite
    nr_vett2=size(Sys2.U,1); %Gli ingressi da collegare vanno messi in cima  
    vett2=Sys2.U;           %%al vettore degli ingressi
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Routine per crare la trasformazione T che mette in fondo al vettore
%vett1 gli elementi che voglio collegare

X0=zeros(nr_vett1,1);
T=[];
for ii=[1:nr_elem1]
    k=ismember(vett1,elem1(ii));      % Creo la matrice T da applicare
    if (max(k)==1)                    % al primo sistema 
        T=[T k];                       
        X0=X0+k;                        
    end
end
ind=find(X0==0);
En=eye(nr_vett1);
T=[En(:,ind) T];                      % Completo la matrice T
SysT1=Trasforma_UY_Sys(Sys1,T);       % Applico una trasformazione ingresso
                                      % uscita utilizzando la matrice T 
                                      % appena creata.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%          

%Routine per crare la trasformazione T che mette in cima al vettore
%vett2 gli elementi che voglio collegare

T=[];                                                 
X0=zeros(nr_vett2,1);                       
for ii=[1:nr_elem2]
    k=ismember(vett2,elem2(ii));       % Creo la matrice T da applicare
    if (max(k)==1)                    % al secondo sistema 
        T=[T k];                        
        X0=X0+k;                      
    end
end
ind=find(X0==0);
En=eye(nr_vett2);                        
T=[T En(:,ind)];                      % Completo la matrice T
SysT2=Trasforma_UY_Sys(Sys2,T);

%Compongo i due sistemi con Autoretroazione

SysT=Autoretroazione_Sys(SysT1,SysT2,W,nr_elem1);

% Show_Sysv2(SysT)
return
