% function SysTa=Autoretroazione_Sys(Sys1,Sys2,W,nr_in)
%
% Questa funzione compone i due sistemi Sys1 e Sys2 passati dall'utente,
% tramite le formule trovate nella teoria.
% L'algoritmo necessita di sapere quante uscite del primo sistema deve
% collegare con gli ingressi del secondo, cio nr_in. 
% Viene inoltre dato il blocco di connessione W.
%
function  SysTa=Autoretroazione_Sys(Sys1,Sys2,W,nr_in)

syms F G U_1 Y_1 

[SysT]=Affianca_Sys (Sys1,Sys2);

% Show_Sysv2(SysT)     

nrUt=size(SysT.U,1);    %dimensione del vettore di ingressi del sitema parallelo dei due sys
nrU_1=size(Sys1.U,1);   %dimensione del vettore di ingressi del primo sistema 
nrU_2=size(Sys2.U,1);   %dimensione del vettore di ingressi del scondo sistema
ii=1;
if(nrU_1==nr_in)                    %se collego tutte le uscite del primo sistema
    U_1= [zeros(0,1);Sys2.U([nrU_2-nr_in+1:nrU_2],1)];                  %creo il nuovo vettore degli ingressi
    ii=0;       
end

if(nrU_2==nr_in)                    %se collego tutti gli ingressi del secondo sistema
  U_1= [Sys1.U([1:nrU_1-nr_in],1);zeros(0,1)];                          %creo il nuovo vettore degli ingressi
  ii=0;      
end

if(nrU_2==nr_in && nrU_1==nr_in )    %se collego tutte le uscite di Sys1 a tutti gli ingressi di Sys2
  U_1= [zeros(0,1);zeros(0,1)];                                         %creo il nuovo vettore degli ingressi
  ii=0; 
end
if ii                               %nessuno dei casi precedenti
    U_1=[Sys1.U([1:nrU_1-nr_in],1);Sys2.U([nr_in+1:nrU_2],1)];    %creo il nuovo vettore degli ingressi
end

nrU_n=size(U_1,1);      %dimensione del vettore di ingressi del nuovo sistema composto

F=sym(zeros(nrUt,nrUt));
F([nrU_1-nr_in+1:nrU_1],[nrU_1+1,nrU_1+nr_in])=-W.';    %Creo matrice F  
F([nrU_1+1:nrU_1+nr_in],[nrU_1-nr_in+1:nrU_1])=W;
G=zeros(nrUt,nrU_n);                                    %Creo la matrice G
G([1:nrU_1-nr_in],[1:nrU_1-nr_in])=eye(nrU_1-nr_in);
G([nrU_1+nr_in+1:nrUt],[nrU_1-nr_in+1:nrU_n])=eye(nrU_2-nr_in);

Y_1=G.'*SysT.Y;

%Applico le formule trovate nella teoria

SysTa.mA=(SysT.mA+SysT.B*inv(eye(nrUt)-F*SysT.D)*F*SysT.C);        
SysTa.B= SysT.B*inv(eye(nrUt)-F*SysT.D)*G;                          
SysTa.C = G.'*inv(eye(nrUt)-SysT.D*F)*SysT.C;
SysTa.D = G.'*SysT.D*inv(eye(nrUt)-F*SysT.D)*G;
SysTa.X=SysT.X;
SysTa.U=U_1;
SysTa.Y=Y_1;
SysTa.L=SysT.L;

return
