%function [SysAt b_T34]= Annulla_colonne_dipendenti(SysA,rho,n)
%
%Questa funzione ha il compito di annullare le colonne lineramente
%dipendenti (l.d) di a_A_22 e di mantenere invece le colonne linearmente
%indipendenti (l.i) mettendole all'inizio di tale matrice.
%Si crea quindi la trasformazione b_T che svolge questa operazione sul
%sistema SysA, restituendo il sistema SysB trasformato e la trasformazione b_T.
%
function [SysAt b_T34]= Annulla_colonne_dipendenti(SysA,rho,n)

a_A_22=SysA.mA([n-rho+1:n],[n-rho+1:n]);
Ker=null(a_A_22);
dim_Ker=size(Ker,2);
rango=zeros(1,rho+1);       % Inizializzo il vettore rango
jj= rho+1;                  % Parto una colonna dopo per entare nel ciclo con rango 0 
while jj>=2
    jj=jj-1;                % Calcolo il rango partendo dall'ultima colonna fino
    B=a_A_22(:,[jj:rho]);     % alla prima colonna di  a_A_22   
    rango(jj)=rank(B) ;                
end                                       
for jj=[1:rho]                      %Con questo ciclo le componenti del
    if rango(jj)==rango(jj+1)+1     %vettore rango relative alle colonne l.i
        rango(jj)=1;                %si pongono a 1 quelle delle colonne l.d
    else                            %si pongono a 0.    
        rango(jj)=0;
    end
end
rango=rango(1:rho);
ind1=find(rango~=0);                %Trovo gli indici delle colonne l.i
En=eye(rho);
T4=Ker;
T3=En(:,ind1);
b_T34=[[eye(n-rho) zeros(n-rho,rho)];[zeros(rho,n-rho) T3 T4]];

%Applico la trasformazione al sistema 'A' per ottenere il sistema 'B'

% SysAt.L=simplify(b_T34.'*SysA.L*b_T34); 
% SysAt.X=inv(b_T34)*SysA.X;
% SysAt.mA=simplify(b_T34.'*SysA.mA*b_T34);
% SysAt.C=simplify(SysA.C*b_T34);
% SysAt.B=simplify(b_T34.'*SysA.B);
% SysAt.D=SysA.D;
% SysAt.U=SysA.U;
% SysAt.Y=SysA.Y;

SysAt=Trasforma_Sys(SysA,b_T34);

return