% function che calcola la matrice di trasformazione T 

function matriceT=matrice_T(theta);

psi2=atan(0.15/1.25);
psi1=atan(0.15/(2.5-1.25));
L1=sqrt(0.15^2+(2.5-1.25)^2);
L2=sqrt(0.15^2+1.25^2);

matriceT= [1   0   L1*sin(psi1-theta)  0 0;
           0   1   L1*cos(psi1-theta)  0 0;
           0   0    0                  1 0;
           1   0   L2*sin(psi2+theta)  0 0;
           0   1  -L2*cos(psi2+theta)  0 0;
           0   0    0                  0 1;
    ];
return

