clear all
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE UNITA' DI MISURA DEL SISTEMA INTERNAZIONALE (SI)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
metri = 1; dm = 0.1*metri; cm = 0.01*metri; mm = 0.001*metri; km = 1000*metri;
kg = 1;
N = 1;
kN = 1000*N;
secondo = 1; ora = 60*60*secondo;  minuti = 60*secondo;
ms = 0.001*secondo;
Pa = 1;
rad = 1;
gradi =( pi/180)*rad;
bar = 10^5*Pa;
lt = 0.001*metri^3;
rpm = 2*pi/60*rad/secondo;
g = 9.8*metri/secondo^2;
Volt=1; Amp=1; Ohm=Volt/Amp;
Henry=Volt*secondo/Amp; Weber=Volt*secondo;
Si=true; Yes=true; No=false;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% DEFINIZIONE E COMPOSIZIONE DEL SISTEMA %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



    syms u_i u_u y_i y_u

    syms b_s r_s w_s Tau_s K_sc d_sc F_sc

    Sys.L=1/K_sc;
    Sys.mA=0;
    Sys.B=[r_s  1];
    Sys.C=[r_s; 1];
    Sys.D=[b_s+r_s^2*d_sc  r_s*d_sc; r_s*d_sc d_sc];
    Sys.X=F_sc;
    Sys.U=[w_s; u_u];
    Sys.Y=[Tau_s; y_u];
    Sys1=Sys;

    W=1;
    Verifica_Sys(Sys1);
   

    % Compongo i due sistemi attraverso la
    % funzione componi la quale necessita
    % dei due sistemi e del blocco W.

    syms J_p J_c b_p b_c r_p r_r w_p w_c Tau_c

    Sys.L=diag([J_p J_c]);
    Sys.mA=-diag([b_p b_c]);
    Sys.B=[-r_p r_p; r_s r_r];
    Sys.C=[-r_p r_s; r_p r_r];
    Sys.D=[0 0; 0 0];
    Sys.X=[w_p; w_c];
    Sys.U=[u_i; u_u];
    Sys.Y=[y_i; y_u];
    Sys2=Sys;

    W=1;                                 % Il blocco W e' bidimensionale
    Sys1=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);

    syms K_cr d_cr F_cr b_r  w_r  Tau_r

    Sys.L=1/K_cr;
    Sys.mA=0;
    Sys.B=[r_r  1];
    Sys.C=[r_r; 1];
    Sys.D=[b_r+r_r^2*d_cr  r_r*d_cr; r_r*d_cr d_cr];
    Sys.X=F_cr;
    Sys.U=[u_i; w_r];
    Sys.Y=[y_i; Tau_r];
    Sys2=Sys;

    W=1;
    SysA=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);
    Show_Sys(SysA)

    SysB=Aggiungi_Ingresso_Sys(SysA,w_c,2,Tau_c,w_c); % Inserire il sistema,
    Show_Sys(SysB)                                % la variabile di stato su
    % cui si vuole agire, il
    % punto in cui inserire il
    % nuovo ingresso, il nuovo
    % ingresso e corrispondente
    % uscita.

   
% return
%     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     %%%%%%%%%%%%%%%%%% RIDUZIONE DEL SISTEMA SOLO INERZIE %%%%%%%%%%%%%%%%%%%%%
%     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
%     Parametri=[1/K_sc 1/K_cr];             % Elementi che voglio mandare a zero
%     Variabili=[w_s w_c];                  % Variabili che cerco di salvare
%     [SysR1 T1]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
%     Show_Sys(SysR1)
%     T1
% 
%     Variabili=[w_c w_r];                 % Variabili che cerco di salvare
%     [SysR2 T2]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
%     Show_Sys(SysR2)
%     T2
% 
%     Variabili=[w_s w_r];                   % Variabili che cerco di salvare
%     [SysR3 T3]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
%     Show_Sys(SysR3)
%     T3

    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%  RIDUZIONE DEL SISTEMA SOLO ELASTICITA'     %%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    Parametri=[J_c J_p];             % Elementi che voglio mandare a zero
    Variabili=[w_c w_p];                  % Variabili che cerco di salvare
    [SysR4 T4]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
    Show_Sys(SysR4)
    T4
    elem=[Tau_c];   % deve appartenere al vettore di ingresso altrimenti non lo vede
    [SysI1 inv_S_N]=Inverti_Sys(SysR4,elem);
%     if inv_S_N 
%         Show_Sys(SysI1)
%     end

return


    Sys.L=diag([J_p]);
    Sys.mA=-diag([b_p]);
    Sys.B=[-r_p r_p];
    Sys.C=[-r_p; r_p];
    Sys.D=[r_s^2/b_c  r_s*r_r/b_c; r_s*r_r/b_c r_r^2/b_c];
    Sys.X=[w_p];
    Sys.U=[u_i; u_u];
    Sys.Y=[y_i; y_u];
    Sys3=Sys;

Verifica_Sys(Sys3);
Show_Sys(Sys3)