clear all
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE UNITA' DI MISURA DEL SISTEMA INTERNAZIONALE (SI)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
metri = 1; dm = 0.1*metri; cm = 0.01*metri; mm = 0.001*metri; km = 1000*metri;
kg = 1;
N = 1;
kN = 1000*N;
secondo = 1; ora = 60*60*secondo;  minuti = 60*secondo;
ms = 0.001*secondo;
Pa = 1;
rad = 1;
gradi =( pi/180)*rad;
bar = 10^5*Pa;
lt = 0.001*metri^3;
rpm = 2*pi/60*rad/secondo;
g = 9.8*metri/secondo^2;
Volt=1; Amp=1; Ohm=Volt/Amp;
Henry=Volt*secondo/Amp; Weber=Volt*secondo;
Si=true; Yes=true; No=false;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% DEFINIZIONE E COMPOSIZIONE DEL SISTEMA %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if Si

    syms u_i u_u y_i y_u

    syms J_s b_s r_s w_s Tau_s

    Sys.L=J_s;
    Sys.mA=-b_s;      % mA sottolinea che deve essere considerato anche il meno
    Sys.B=[1 r_s];
    Sys.C=[1; r_s];
    Sys.D=[0 0; 0 0];
    Sys.X=w_s;
    Sys.U=[Tau_s; u_u];
    Sys.Y=[w_s; y_u];
    Sys1=Sys;

    syms K_sc d_sc F_sc

    Sys.L=1/K_sc;
    Sys.mA=0;
    Sys.B=[1  1];
    Sys.C=[1; 1];
    Sys.D=[d_sc d_sc; d_sc d_sc];
    Sys.X=F_sc;
    Sys.U=[u_i; u_u];
    Sys.Y=[y_i; y_u];
    Sys2=Sys;

    W=1;
    Verifica_Sys(Sys1);
    Verifica_Sys(Sys2);
    Sys1=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);

    % Compongo i due sistemi attraverso la
    % funzione componi la quale necessita
    % dei due sistemi e del blocco W.

    syms J_p J_c b_p b_c r_p r_r w_p w_c Tau_c

    Sys.L=diag([J_p J_c]);
    Sys.mA=-diag([b_p b_c]);
    Sys.B=[-r_p r_p; r_s r_r];
    Sys.C=[-r_p r_s; r_p r_r];
    Sys.D=[0 0; 0 0];
    Sys.X=[w_p; w_c];
    Sys.U=[u_i; u_u];
    Sys.Y=[y_i; y_u];
    Sys2=Sys;

    W=1;                                 % Il blocco W e' bidimensionale
    Sys1=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);

    syms K_cr d_cr F_cr

    Sys.L=1/K_cr;
    Sys.mA=0;
    Sys.B=[1  1];
    Sys.C=[1; 1];
    Sys.D=[d_cr d_cr; d_cr d_cr];
    Sys.X=F_cr;
    Sys.U=[u_i; u_u];
    Sys.Y=[y_i; y_u];
    Sys2=Sys;

    W=1;
    Sys1=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);

    syms J_r  b_r  w_r  Tau_r

    Sys.L=J_r;
    Sys.mA=-b_r;
    Sys.B=[r_r 1];
    Sys.C=[r_r; 1];
    Sys.D=[0 0; 0 0];
    Sys.X=w_r;
    Sys.U=[u_i;Tau_r];
    Sys.Y=[y_i;w_r];
    Sys2=Sys;

    W=1;
    SysA=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);
    Show_Sys(SysA)

    SysB=Aggiungi_Ingresso_Sys(SysA,w_c,2,Tau_c,w_c); % Inserire il sistema,
    Show_Sys(SysB)                                % la variabile di stato su
    % cui si vuole agire, il
    % punto in cui inserire il
    % nuovo ingresso, il nuovo
    % ingresso e corrispondente
    % uscita.

% return
%     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     %%%%%%%%%%%%%%%%%% RIDUZIONE DEL SISTEMA SOLO INERZIE %%%%%%%%%%%%%%%%%%%%%
%     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
%     Parametri=[1/K_sc 1/K_cr];             % Elementi che voglio mandare a zero
%     Variabili=[w_s w_c];                  % Variabili che cerco di salvare
%     [SysR1 T1]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
%     Show_Sys(SysR1)
%     T1
% 
%     Variabili=[w_c w_r];                 % Variabili che cerco di salvare
%     [SysR2 T2]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
%     Show_Sys(SysR2)
%     T2
% 
%     Variabili=[w_s w_r];                   % Variabili che cerco di salvare
%     [SysR3 T3]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
%     Show_Sys(SysR3)
%     T3

    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%  RIDUZIONE DEL SISTEMA SOLO ELASTICITA'     %%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    Parametri=[J_s J_c J_p J_r];             % Elementi che voglio mandare a zero
    Variabili=[w_s w_c w_r];                  % Variabili che cerco di salvare
    [SysR4 T4]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
    Show_Sys(SysR4)
    T4
    elem=[w_s w_c w_r];
    [SysI1 inv_S_N]=Inverti_Sys(SysR4,elem);
    if inv_S_N 
        Show_Sys(SysI1)
    end
end

