clear all
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE UNITA' DI MISURA DEL SISTEMA INTERNAZIONALE (SI)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
m = 1; dm = 0.1*m; cm = 0.01*m; mm = 0.001*m; km = 1000*m;
kg = 1;
N = 1;
kN = 1000*N;
secondo = 1; ora = 60*60*secondo;  minuti = 60*secondo;
ms = 0.001*secondo;
Pa = 1;
rad = 1;
gradi =( pi/180)*rad;
bar = 10^5*Pa;
lt = 0.001*m^3;
rpm = 2*pi/60*rad/secondo;
g = 9.8*m/secondo^2;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%  DEFINIZIONE DEI PARAMETRI E SIMULAZIONE  %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rho_acc=7.5*kg/dm^3;  % Densit dell'acciaio 
kb=100;               % Coefficiente di proporzionalit tra il coefficiente
                      % di attrito b e l'inerzia J_m di una ruota
                      
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE VARIABILI STANDARD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% PASSO LINEARE DEI DENTI
xd=2*cm;
xds=xd;
xd0=xd;

%%% SPESSORE DELLE RUOTE DENTATE (LARGHEZZA DEI DENTI)
hr=3*cm;
hs=3*cm;
hc=3*cm;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE CARATTERISTICHE FISICHE DEL SISTEMA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%% Routa "r" Ring gruppo epicicloidale

Nr=78;                     % Numero denti del ring
h_ring=9*cm;               % Altezza ring
diff_r=1.2*cm;             % Differenza tra raggio interno e raggio esterno 
r_ri=xds*Nr/(2*pi);
r_re=r_ri+diff_r;
J_r=0.5*pi*rho_acc*(hr*r_ri^4 + h_ring*(r_re^4-r_ri^4));          % Inerzia
b_r=kb*J_r;                                                       % Attrito

%%%% Routa "s" Satellite gruppo epicicloidale

Ns=23;                                 % Numero di denti dei satelliti
r_s=xds*Ns/(2*pi);                        
Nr_sat=4;                              % Numero dei satelliti
J_s=Nr_sat*0.5*pi*rho_acc*(hs*r_s^4 + hc*r_s^4);    
b_s=kb*J_s;                                          

%%%% Routa "c" Solare gruppo epicicloidale

Nc=30;
r_c=r_ri-2*r_s;
J_c=1.3*0.5*pi*rho_acc*hc*r_c^4;
b_c=kb*J_c;

%%%% Routa "cs" Satelliti-solare gruppo epicicloidale

J_sc=Nr_sat*(r_c+r_s)^2*rho_acc*pi*(hs*r_s^2 + hc*r_s^2);
b_sc=kb*J_sc;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   PARAMETRI ELASTICI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
K0=10000000;  
d0=10;

K_cs=K0;
d_cs=d0;

K_sr=K0;
d_sr=d0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   SEGNALI ESTERNI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Tau_sc=4*N*m;                          % Coppia al portasatelliti
Tau_c=0*N*m;                           % Coppia al solare
Tau_r=0*N*m;                           % Coppia al ring

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   CONDIZIONI INIZIALI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Wc_0 = 0.1*rad/secondo;                % Velocit iniziale solare
Wsc_0= -0.2*rad/secondo;               % Velocit iniziale portasatelliti
Wr_0 = [ -1/r_ri*r_c, (r_c+r_ri)/r_ri]*[Wc_0; Wsc_0];      % Velocit iniziale ring

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   SIMULAZIONE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Tc=0.05*ms;                            % Switching period
Tfin=0.1*secondo;                      % Durata simulazione
tic
sim('epicicloidale_esteso_mdl',Tfin);  % Simulazione epicicloidale
toc
% Tipo_di_Modello=3
% W1_0=Wc_0;  
% W2_0=Wr_0;
% sim('epicicloidale_small_mdl',Tfin); % Simulazione epicicloidale

rid=10;
nr_t=length(t);
xx=(1:rid:nr_t);

figure(1)
clf
subplot(211)
plot(t(xx),W_c(xx),'b','LineWidth',3)
hold on
title('Velocit del solare')
ylabel('Wc [rad/s]')
xlabel('Time [s]')
zoom on
grid on

figure(2)
clf
plot(t,W_sc,'b','LineWidth',3)
hold on
title('Velocit del portasatelliti')
ylabel('Wsc [rad/s]')
xlabel('Time [s]')
zoom on
grid on

figure(3)
clf
plot(t,W_r,'b','LineWidth',3)
hold on
title('Velocit del ring')
ylabel('Wr [rad/s]')
xlabel('Time [s]')
zoom on
grid on

tic
sim('epicicloidale_both_mdl',Tfin); % Simulazione epicicloidale ridotto
toc

figure(1)
subplot(211)
plot(t(xx),W_c(xx),'m--','LineWidth',2)
legend('modello esteso','modello ridotto')

figure(2)
plot(t,W_sc,'m--','LineWidth',2)

figure(3)
plot(t,W_r,'m--','LineWidth',2)

% 
% sim('epicicloidale_both_esteso_mdl',Tfin); % Simulazione epicicloidale ridotto
% 
% figure(1)
% plot(t,W_c,'m:','LineWidth',3)
% legend('modello esteso','modello ridotto')
% 
% figure(2)
% plot(t,W_sc,'m:','LineWidth',3)
% legend('modello esteso','modello ridotto')
% 
% figure(3)
% plot(t,W_r,'m:','LineWidth',3)
% legend('modello esteso','modello ridotto')
