clear all
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE UNITA' DI MISURA DEL SISTEMA INTERNAZIONALE (SI)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
metri = 1; dm = 0.1*metri; cm = 0.01*metri; mm = 0.001*metri; km = 1000*metri;
kg = 1;
N = 1;
kN = 1000*N;
secondo = 1; ora = 60*60*secondo;  minuti = 60*secondo;
ms = 0.001*secondo;
Pa = 1;
rad = 1;
gradi =( pi/180)*rad;
bar = 10^5*Pa;
lt = 0.001*metri^3;
rpm = 2*pi/60*rad/secondo;
g = 9.8*metri/secondo^2;
Volt=1; Amp=1; Ohm=Volt/Amp;
Henry=Volt*secondo/Amp; Weber=Volt*secondo;
Si=true; Yes=true; No=false;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%  DEFINIZIONE DEI PARAMETRI EPICICLOIDALE  %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rho_acc=7.5*kg/dm^3;  % Densit dell'acciaio 
kb=100;               % Coefficiente di proporzionalit tra il coefficiente
                      % di attrito b e l'inerzia J_m di una ruota
                      
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE VARIABILI STANDARD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% PASSO LINEARE DEI DENTI
xd=2*cm;
xds=xd;
xd0=xd;

%%% SPESSORE DELLE RUOTE DENTATE (LARGHEZZA DEI DENTI)
hr=3*cm;
hs=3*cm;
hc=3*cm;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE CARATTERISTICHE FISICHE DEL SISTEMA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%% Ruota "r" Ring gruppo epicicloidale

Nr=78;                     % Numero denti del ring
h_ring=9*cm;               % Altezza ring
diff_r=1.2*cm;             % Differenza tra raggio interno e raggio esterno 
r_r=xds*Nr/(2*pi);
r_re=r_r+diff_r;
J_r=0.5*pi*rho_acc*(hr*r_r^4 + h_ring*(r_re^4-r_r^4));          % Inerzia
b_r=kb*J_r;                                                       % Attrito

%%%% Ruota "p" Pianeta gruppo epicicloidale

Np=23;                                 % Numero di denti dei satelliti
r_p=xds*Np/(2*pi);                        
Nr_sat=4;                              % Numero dei satelliti
J_p=Nr_sat*0.5*pi*rho_acc*(hs*r_p^4 + hc*r_p^4);    
b_p=kb*J_p;                                          

%%%% Ruota "s" Solare gruppo epicicloidale

Ns=30;
r_s=r_r-2*r_p;
J_s=1.3*0.5*pi*rho_acc*hc*r_s^4;
b_s=kb*J_s;

%%%% Ruota "c" Satelliti-solare gruppo epicicloidale

J_c=Nr_sat*(r_s+r_p)^2*rho_acc*pi*(hs*r_p^2 + hc*r_p^2);
b_c=kb*J_c;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   PARAMETRI ELASTICI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
K0=10000;  
d0=10;

K_sc=K0;
d_sc=d0;

K_cr=K0;
d_cr=d0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   SEGNALI ESTERNI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Tau_c=10*N*metri;                          % Coppia al portasatelliti
Tau_s=5*N*metri;                           % Coppia al solare
Tau_r=20*N*metri;                           % Coppia al ring

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   CONDIZIONI INIZIALI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Ws_0 = 0.1*rad/secondo;                % Velocit iniziale solare
Wc_0= -0.2*rad/secondo;               % Velocit iniziale portasatelliti
Wr_0 = [-r_s/r_r, 1+r_s/r_r]*[Ws_0; Wc_0];      % Velocit iniziale ring

Ts_0=0*N*metri;
Tc_0=0*N*metri;
Tr_0=0*N*metri;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   SIMULAZIONE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


Tc=0.05*ms;                            % Switching period
Tfin=1*secondo;                      % Durata simulazione
Ts=Tfin/2000;


% return
sim('epicicloidale_confronto_statico_elastico_mdl',Tfin);    % Simulazione epicicloidale 

Lw=1.5;
figure(1)
clf
plot(t,W,'b','LineWidth',Lw)
hold on
plot(t,W1,'r','LineWidth',Lw)
plot(t,W2,'g','LineWidth',Lw)
title('Velocit W1 (r), W2 (g) e W (b)')
ylabel('W [rad/s]')
xlabel('Time [s]')
zoom on
grid on

figure(2)
clf
plot(t,W4,'b','LineWidth',Lw)
hold on
plot(t,W1,'r','LineWidth',Lw)
plot(t,W2,'g','LineWidth',Lw)
title('Velocit W5 (r), W3 (g) e W4 (b)')
ylabel('W [rad/s]')
xlabel('Time [s]')
zoom on
grid on

figure(3)
clf
plot(t,Tau3,'b','LineWidth',Lw)
hold on
plot(t,Tau1,'r','LineWidth',Lw)
plot(t,Tau2,'g','LineWidth',Lw)
title('Coppie Tau1 (r), Tau2 (g) e Tau3 (b)')
ylabel('Tau [N m]')
xlabel('Time [s]')
zoom on
grid on

figure(4)
clf
plot(t,Tau_c1,'b','LineWidth',Lw)
hold on
plot(t,Tau_s1,'r','LineWidth',Lw)
plot(t,Tau_r1,'g','LineWidth',Lw)
title('Coppie Tau_s1 (r), Tau_r1 (g) e Tau_c1 (b)')
ylabel('Tau [N m]')
xlabel('Time [s]')
zoom on
grid on

