clear all
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE UNITA' DI MISURA DEL SISTEMA INTERNAZIONALE (SI)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
m = 1; dm = 0.1*m; cm = 0.01*m; mm = 0.001*m; km = 1000*m;
kg = 1;
N = 1;
kN = 1000*N;
secondo = 1; ora = 60*60*secondo;  minuti = 60*secondo;
ms = 0.001*secondo;
Pa = 1;
rad = 1;
gradi =( pi/180)*rad;
bar = 10^5*Pa;
lt = 0.001*m^3;
rpm = 2*pi/60*rad/secondo;
g = 9.8*m/secondo^2;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% DEFINIZIONE E COMPOSIZIONE DEL SISTEMA %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

syms u_i u_u y_i y_u

syms J_c b_c r_c w_c Tau_c

Sys.L=J_c;
Sys.mA=-b_c;      % mA sottolinea che deve essere considerato anche il meno
Sys.B=[1 r_c];
Sys.C=[1; r_c];
Sys.D=[0 0; 0 0];
Sys.X=w_c;
Sys.U=[Tau_c; u_u];
Sys.Y=[w_c; y_u];
Sys1=Sys;

syms K_cs d_cs F_cs

Sys.L=1/K_cs;
Sys.mA=0;      
Sys.B=[1  1];
Sys.C=[1; 1];
Sys.D=[d_cs d_cs; d_cs d_cs];
Sys.X=F_cs;
Sys.U=[u_i; u_u];
Sys.Y=[y_i; y_u];
Sys2=Sys;

W=1;
Verifica_Sys(Sys1);
Verifica_Sys(Sys2);
Sys1=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);   

                                     % Compongo i due sistemi attraverso la 
                                     % funzione componi la quale necessita 
                                     % dei due sistemi e del blocco W.
                                 
syms J_s J_sc b_s b_sc r_s r_ri w_s w_sc Tau_sc

Sys.L=diag([J_s J_sc]);
Sys.mA=-diag([b_s b_sc]);
Sys.B=[-r_s r_s; r_c r_ri];
Sys.C=[-r_s r_c; r_s r_ri];
Sys.D=[0 0; 0 0];
Sys.X=[w_s; w_sc];
Sys.U=[u_i; u_u];
Sys.Y=[y_i; y_u];
Sys2=Sys;

W=1;                                 % Il blocco W e' bidimensionale
Sys1=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);

syms K_sr d_sr F_sr

Sys.L=1/K_sr;
Sys.mA=0;
Sys.B=[1  1];
Sys.C=[1; 1];
Sys.D=[d_sr d_sr; d_sr d_sr];
Sys.X=F_sr;
Sys.U=[u_i; u_u];
Sys.Y=[y_i; y_u];
Sys2=Sys;

W=1;                                        
Sys1=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);

syms J_r  b_r  w_r  Tau_r 

Sys.L=J_r;
Sys.mA=-b_r;
Sys.B=[r_ri 1];
Sys.C=[r_ri; 1];
Sys.D=[0 0; 0 0];
Sys.X=w_r;
Sys.U=[u_i;Tau_r];
Sys.Y=[y_i;w_r];
Sys2=Sys;

W=1;
SysA=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);
Show_Sys(SysA)

SysB=Aggiungi_Ingresso_Sys(SysA,w_sc,2,Tau_sc,w_sc); % Inserire il sistema, 
Show_Sys(SysB)                                % la variabile di stato su 
                                              % cui si vuole agire, il  
                                              % punto in cui inserire il 
                                              % nuovo ingresso, il nuovo
                                              % ingresso e corrispondente
                                              % uscita.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%% RIDUZIONE DEL SISTEMA %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Parametri=[1/K_cs 1/K_sr];             % Elementi che voglio mandare a zero
Variabili=[w_c w_sc];                  % Variabili che cerco di salvare 
[SysR1 T1]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
Show_Sys(SysR1)
T1

Variabili=[w_sc w_r];                 % Variabili che cerco di salvare 
[SysR2 T2]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
Show_Sys(SysR2)
T2

Variabili=[w_c w_r];                   % Variabili che cerco di salvare 
[SysR3 T3]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
Show_Sys(SysR3)
T3

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%  DEFINIZIONE DEI PARAMETRI E SIMULAZIONE  %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rho_acc=7.5*kg/dm^3;  % Densit dell'acciaio 
kb=100;               % Coefficiente di proporzionalit tra il coefficiente
                      % di attrito b e l'inerzia J_m di una ruota
                      
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE VARIABILI STANDARD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% PASSO LINEARE DEI DENTI
xd=2*cm;
xds=xd;
xd0=xd;

%%% SPESSORE DELLE RUOTE DENTATE (LARGHEZZA DEI DENTI)
hr=3*cm;
hs=3*cm;
hc=3*cm;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE CARATTERISTICHE FISICHE DEL SISTEMA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%% Routa "r" Ring gruppo epicicloidale

Nr=78;                     % Numero denti del ring
h_ring=9*cm;               % Altezza ring
diff_r=1.2*cm;             % Differenza tra raggio interno e raggio esterno 
r_ri=xds*Nr/(2*pi);
r_re=r_ri+diff_r;
J_r=0.5*pi*rho_acc*(hr*r_ri^4 + h_ring*(r_re^4-r_ri^4));          % Inerzia
b_r=kb*J_r;                                                       % Attrito

%%%% Routa "s" Satellite gruppo epicicloidale

Ns=23;                                 % Numero di denti dei satelliti
r_s=xds*Ns/(2*pi);                        
Nr_sat=4;                              % Numero dei satelliti
J_s=Nr_sat*0.5*pi*rho_acc*(hs*r_s^4 + hc*r_s^4);    
b_s=kb*J_s;                                          

%%%% Routa "c" Solare gruppo epicicloidale

Nc=30;
r_c=r_ri-2*r_s;
J_c=1.3*0.5*pi*rho_acc*hc*r_c^4;
b_c=kb*J_c;

%%%% Routa "cs" Satelliti-solare gruppo epicicloidale

J_sc=Nr_sat*(r_c+r_s)^2*rho_acc*pi*(hs*r_s^2 + hc*r_s^2);
b_sc=kb*J_sc;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   PARAMETRI ELASTICI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
K0=10000000;  
d0=10;

K_cs=K0;
d_cs=d0;

K_sr=K0;
d_sr=d0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   SEGNALI ESTERNI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Tau_sc=4*N*m;                          % Coppia al portasatelliti
Tau_c=0*N*m;                           % Coppia al solare
Tau_r=0*N*m;                           % Coppia al ring

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Sys1=SysR1;
% Rtras=cross(Sys1.B(1,:),Sys1.B(2,:));
% Rap_Tras=double(subs(Rtras(2)/Rtras(1)));     % Rapporto di trasmissione

Sys1.L=vpa(subs(Sys1.L),50);                     
Sys1.mA=vpa(subs(Sys1.mA),50);
Sys1.B=vpa(subs(Sys1.B),50);                  
Sys1.C=vpa(subs(Sys1.C),50);           % Sostituzioni simboliche
Sys1.D=vpa(subs(Sys1.D),50);
Sys1.Y=vpa(subs(Sys1.Y));

Show_Sys(Sys1)

Sys2=SysR2;

Sys2.L=vpa(subs(Sys2.L),50);                     
Sys2.mA=vpa(subs(Sys2.mA),50);
Sys2.B=vpa(subs(Sys2.B),50);                  
Sys2.C=vpa(subs(Sys2.C),50);           % Sostituzioni simboliche
Sys2.D=vpa(subs(Sys2.D),50);
Sys2.Y=vpa(subs(Sys2.Y));

Show_Sys(Sys2)

Sys3=SysR3;

Sys3.L=vpa(subs(Sys3.L),50);                     
Sys3.mA=vpa(subs(Sys3.mA),50);
Sys3.B=vpa(subs(Sys3.B),50);                  
Sys3.C=vpa(subs(Sys3.C),50);           % Sostituzioni simboliche
Sys3.D=vpa(subs(Sys3.D),50);
Sys3.Y=vpa(subs(Sys3.Y));

Show_Sys(Sys3)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   CONDIZIONI INIZIALI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Wc_0 = 0.1*rad/secondo;                % Velocit iniziale solare
Wsc_0= -0.2*rad/secondo;               % Velocit iniziale portasatelliti
Wr_0 = Sys1.C(3,:)*[Wc_0; Wsc_0];      % Velocit iniziale ring

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   SIMULAZIONE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Tc=0.05*ms;                            % Switching period
Tfin=0.1*secondo;                      % Durata simulazione
Ts=Tfin/2000;
sim('epicicloidale_esteso_mdl',Tfin);  % Simulazione epicicloidale

figure(1)
clf
plot(t,W_c,'b','LineWidth',3)
hold on
title('Velocit del solare')
ylabel('W_c [rad/s]')
xlabel('Time [s]')
zoom on
grid on

figure(2)
clf
plot(t,W_sc,'b','LineWidth',3)
hold on
title('Velocit del portasatelliti')
ylabel('W_{sc} [rad/s]')
xlabel('Time [s]')
zoom on
grid on

figure(3)
clf
plot(t,W_r,'b','LineWidth',3)
hold on
title('Velocit del ring')
ylabel('W_r [rad/s]')
xlabel('Time [s]')

zoom on
grid on

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

sim('epicicloidale_both_mdl',Tfin);    % Simulazione epicicloidale ridotto

figure(1)
plot(t,W_c,'m:','LineWidth',3)
legend('modello esteso','modello ridotto')

figure(2)
plot(t,W_sc,'m:','LineWidth',3)

figure(3)
plot(t,W_r,'m:','LineWidth',3)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% sim('epicicloidale_both_esteso_mdl',Tfin); % Simulazione epicicloidale esteso
% 
% figure(1)
% plot(t,W_c,'g-.','LineWidth',3)
% 
% figure(2)
% plot(t,W_sc,'g-.','LineWidth',3)
% 
% figure(3)
% plot(t,W_r,'g-.','LineWidth',3)
