clear all
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE UNITA' DI MISURA DEL SISTEMA INTERNAZIONALE (SI)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
metri = 1; dm = 0.1*metri; cm = 0.01*metri; mm = 0.001*metri; km = 1000*metri;
kg = 1;
N = 1;
kN = 1000*N;
secondo = 1; ora = 60*60*secondo;  minuti = 60*secondo;
ms = 0.001*secondo;
Pa = 1;
rad = 1;
gradi =( pi/180)*rad;
bar = 10^5*Pa;
lt = 0.001*metri^3;
rpm = 2*pi/60*rad/secondo;
g = 9.8*metri/secondo^2;
Volt=1; Amp=1; Ohm=Volt/Amp;
Henry=Volt*secondo/Amp; Weber=Volt*secondo;
Si=true; Yes=true; No=false;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% DEFINIZIONE E COMPOSIZIONE DEL SISTEMA %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

syms u_i u_u y_i y_u

syms J_c b_c r_c w_c Tau_c

Sys.L=J_c;
Sys.mA=-b_c;      % mA sottolinea che deve essere considerato anche il meno
Sys.B=[1 r_c];
Sys.C=[1; r_c];
Sys.D=[0 0; 0 0];
Sys.X=w_c;
Sys.U=[Tau_c; u_u];
Sys.Y=[w_c; y_u];
Sys1=Sys;

syms K_cs d_cs F_cs

Sys.L=1/K_cs;
Sys.mA=0;      
Sys.B=[1  1];
Sys.C=[1; 1];
Sys.D=[d_cs d_cs; d_cs d_cs];
Sys.X=F_cs;
Sys.U=[u_i; u_u];
Sys.Y=[y_i; y_u];
Sys2=Sys;

W=1;
Verifica_Sys(Sys1);
Verifica_Sys(Sys2);
Sys1=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);   

                                     % Compongo i due sistemi attraverso la 
                                     % funzione componi la quale necessita 
                                     % dei due sistemi e del blocco W.
                                 
syms J_s J_sc b_s b_sc r_s r_ri w_s w_sc Tau_sc

Sys.L=diag([J_s J_sc]);
Sys.mA=-diag([b_s b_sc]);
Sys.B=[-r_s r_s; r_c r_ri];
Sys.C=[-r_s r_c; r_s r_ri];
Sys.D=[0 0; 0 0];
Sys.X=[w_s; w_sc];
Sys.U=[u_i; u_u];
Sys.Y=[y_i; y_u];
Sys2=Sys;

W=1;                                 % Il blocco W e' bidimensionale
Sys1=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);

syms K_sr d_sr F_sr

Sys.L=1/K_sr;
Sys.mA=0;
Sys.B=[1  1];
Sys.C=[1; 1];
Sys.D=[d_sr d_sr; d_sr d_sr];
Sys.X=F_sr;
Sys.U=[u_i; u_u];
Sys.Y=[y_i; y_u];
Sys2=Sys;

W=1;                                        
Sys1=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);

syms J_r  b_r  w_r  Tau_r 

Sys.L=J_r;
Sys.mA=-b_r;
Sys.B=[r_ri 1];
Sys.C=[r_ri; 1];
Sys.D=[0 0; 0 0];
Sys.X=w_r;
Sys.U=[u_i;Tau_r];
Sys.Y=[y_i;w_r];
Sys2=Sys;

W=1;
SysA=Componi_Sys(Sys1,Sys2,[y_u],[u_i],W);
Show_Sys(SysA)

SysB=Aggiungi_Ingresso_Sys(SysA,w_sc,2,Tau_sc,w_sc); % Inserire il sistema, 
Show_Sys(SysB)                                % la variabile di stato su 
                                              % cui si vuole agire, il  
                                              % punto in cui inserire il 
                                              % nuovo ingresso, il nuovo
                                              % ingresso e corrispondente
                                              % uscita.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%% RIDUZIONE DEL SISTEMA %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Parametri=[1/K_cs 1/K_sr];             % Elementi che voglio mandare a zero
Variabili=[w_c w_sc];                  % Variabili che cerco di salvare 
[SysR1 T1]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
Show_Sys(SysR1)
T1

Variabili=[w_sc w_r];                 % Variabili che cerco di salvare 
[SysR2 T2]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
Show_Sys(SysR2)
T2

Variabili=[w_c w_r];                   % Variabili che cerco di salvare 
[SysR3 T3]=Riduci_Sys(SysB,Parametri,Variabili); % Riduzione del sistema
Show_Sys(SysR3)
T3

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%  DEFINIZIONE DEI PARAMETRI EPICICLOIDALE  %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rho_acc=7.5*kg/dm^3;  % Densit dell'acciaio 
kb=100;               % Coefficiente di proporzionalit tra il coefficiente
                      % di attrito b e l'inerzia J_m di una ruota
                      
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE VARIABILI STANDARD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% PASSO LINEARE DEI DENTI
xd=2*cm;
xds=xd;
xd0=xd;

%%% SPESSORE DELLE RUOTE DENTATE (LARGHEZZA DEI DENTI)
hr=3*cm;
hs=3*cm;
hc=3*cm;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE CARATTERISTICHE FISICHE DEL SISTEMA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%% Ruota "r" Ring gruppo epicicloidale

Nr=78;                     % Numero denti del ring
h_ring=9*cm;               % Altezza ring
diff_r=1.2*cm;             % Differenza tra raggio interno e raggio esterno 
r_ri=xds*Nr/(2*pi);
r_re=r_ri+diff_r;
J_r=0.5*pi*rho_acc*(hr*r_ri^4 + h_ring*(r_re^4-r_ri^4));          % Inerzia
b_r=kb*J_r;                                                       % Attrito

%%%% Ruota "s" Satellite gruppo epicicloidale

Ns=23;                                 % Numero di denti dei satelliti
r_s=xds*Ns/(2*pi);                        
Nr_sat=4;                              % Numero dei satelliti
J_s=Nr_sat*0.5*pi*rho_acc*(hs*r_s^4 + hc*r_s^4);    
b_s=kb*J_s;                                          

%%%% Ruota "c" Solare gruppo epicicloidale

Nc=30;
r_c=r_ri-2*r_s;
J_c=1.3*0.5*pi*rho_acc*hc*r_c^4;
b_c=kb*J_c;

%%%% Ruota "cs" Satelliti-solare gruppo epicicloidale

J_sc=Nr_sat*(r_c+r_s)^2*rho_acc*pi*(hs*r_s^2 + hc*r_s^2);
b_sc=kb*J_sc;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   PARAMETRI ELASTICI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
K0=10000000;  
d0=10;

K_cs=K0;
d_cs=d0;

K_sr=K0;
d_sr=d0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%    DEFINIZIONE PARAMETRI DEL MOTORE ELETTRICO     %%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  Flusso rotorico: parte magnetica del motore
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%%% Tipi di flusso rotorico 

Flusso(1)=struct('Nome','Trapezoidale', ...
                 'Tipo','[1,pi/4]', ...
                 'Simbolo','Phit(al,th)');
Flusso(2)=struct('Nome','Triangolare', ...
                 'Tipo','[1, 0]', ...
                 'Simbolo','Phi1(th)');
Flusso(3)=struct('Nome','Ad_onda_quadra', ...
                 'Tipo','[2]', ...
                 'Simbolo','Phi0(th)');
Flusso(4)=struct('Nome','Sinusoidale', ...
                 'Tipo','[3]', ...
                 'Simbolo','Cos(th)');
Flusso(5)=struct('Nome','Raccordo_cosinusoidale', ...
                 'Tipo','[4,pi/4]', ...
                 'Simbolo','Phic(al,th)');
Flusso(6)=struct('Nome','Raccordo_sinusoidale', ...
                 'Tipo','[5,pi/8]', ...
                 'Simbolo','Phis(al,th)');
Flusso(7)=struct('Nome','Polinomiale_pari', ...
                 'Tipo','[6,0.5*pi/8,6]', ...
                 'Simbolo','Phiq(al,th)');
Flusso(8)=struct('Nome','Polinomiale_dispari', ...
                 'Tipo','[7,3*pi/8,9]', ...
                 'Simbolo','Phir(al,th)');
Flusso(9)=struct('Nome','Derivata_trapezoidale', ...
                 'Tipo','[8,pi/4]', ...
                 'Simbolo','Phid(al,th)');
Flusso(10)=struct('Nome','Definito_dallo_spettro', ...
                 'Tipo','[9,Nmax,CompAi]', ...
                 'Simbolo','Spettro');
Flusso(11)=struct('Nome','Definito_dallo_spettro', ...
                 'Tipo','[9,Nmax,CompAi]', ...
                 'Simbolo','Spettro');
Flusso(12)=struct('Nome','Definito_dallo_spettro', ...
                 'Tipo','[9,Nmax,CompAi]', ...
                 'Simbolo','Spettro');

   

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  Electric parameters of the motor
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
m=5;                    % Nr of motor phases
p=1;                    % Nr of polar expansion
Nar=200;                % Nr of harmonics in the Fourier series
%
Nc=30;                 % Number of coils for each phase (p=1)
Li=0.1*Henry;           % i-th self inductance coefficient (p=1)
Mi=0.08*Henry;          % ij-th mutual inductance coefficient (p=1)
Ri=3*Ohm;               % i-th resistance (p=1)
Star=Si;               % Are the inductances "star-connected"? [Yes, No]
%
Jm=1.6*kg*metri^2;      % Rotor inertia momentum
bm=0.8*N*metri*secondo/rad;      % Rotor linear friction coefficient
%
Phir = 0.02*Weber;      % Maximum value of the rotor flux
Nmax=m;

%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% Ingressi del sistema
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
Vmax=100*Volt;                      % Tensione massima in ingresso
V_in    = Vmax*ones(1,m)';          % Ampiezze
Phi_in  = pi/2 -2*pi*[0:m-1]'/m ;   % Fasi
Freq_in = 3*2*pi;                   % Pulsazione
Ce=0;                               % Coppia resistente
Tau_d=1*N*metri;                   % Coppia desiderata
Wr_d=(Tau_d-Ce)/bm;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tTb=T_b_Concordia(m);       %%% Trasformazione "T(b->t)": matrice tTb;

MKr= zeros(m);              %%% Trasformazione "T(b->w)": matrici MKr, Jr e I_m;
for j=[1:2:m-1]
    MKr(j,j)= j;  MKr(j+1,j+1)= j;
end
Jr= zeros(m);
for j=[2:2:m]
    Jr(j-1,j)= 1;  Jr(j,j-1)=-1;
end
I_m=eye(m);

MLb=p*eye(m)*(Li-Mi);       %%% Auto and mutual inductance matrix MLb 
MLb(1,1)=p*(Li+(m-2)*Mi/2); %%% defined in the rotating frame
MLb(2,2)=p*(Li+(m-2)*Mi/2);

MR = p*Ri*eye(m);           %%% Resistance matrice MR defined in the rotating frame
%
Kr= zeros(m,1);             %%% Matrix Kr for the energy redistribution "j*w*L"
for j=[1:2:m-1]
    Kr(j)= j;  Kr(j+1)= j;
end
%
Phic = p*Nc*Phir;           %%% Maximum value of the concatenated flux;
%
%
if Star        %%% Reduction of the system matrices if Star is True
    tTb=tTb(:,[1:m-1]);
    MKr=MKr([1:m-1],[1:m-1]);
    Jr=Jr([1:m-1],[1:m-1]);
    I_m=eye(m-1);
    MLb=MLb([1:m-1],[1:m-1]);
    MR=MR([1:m-1],[1:m-1]);
    Kr=Kr([1:m-1]);
end


   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   SEGNALI ESTERNI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Tau_sc=200*N*metri;                          % Coppia al portasatelliti
Tau_c=0*N*metri;                           % Coppia al solare
Tau_r=0*N*metri;                           % Coppia al ring

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Sys1=SysR1;
% Rtras=cross(Sys1.B(1,:),Sys1.B(2,:));
% Rap_Tras=double(subs(Rtras(2)/Rtras(1)));     % Rapporto di trasmissione

Sys1.L=vpa(subs(Sys1.L),50);                     
Sys1.mA=vpa(subs(Sys1.mA),50);
Sys1.B=vpa(subs(Sys1.B),50);                  
Sys1.C=vpa(subs(Sys1.C),50);           % Sostituzioni simboliche
Sys1.D=vpa(subs(Sys1.D),50);
Sys1.Y=vpa(subs(Sys1.Y));

Show_Sys(Sys1)

Sys2=SysR2;

Sys2.L=vpa(subs(Sys2.L),50);                     
Sys2.mA=vpa(subs(Sys2.mA),50);
Sys2.B=vpa(subs(Sys2.B),50);                  
Sys2.C=vpa(subs(Sys2.C),50);           % Sostituzioni simboliche
Sys2.D=vpa(subs(Sys2.D),50);
Sys2.Y=vpa(subs(Sys2.Y));

Show_Sys(Sys2)

Sys3=SysR3;

Sys3.L=vpa(subs(Sys3.L),50);                     
Sys3.mA=vpa(subs(Sys3.mA),50);
Sys3.B=vpa(subs(Sys3.B),50);                  
Sys3.C=vpa(subs(Sys3.C),50);           % Sostituzioni simboliche
Sys3.D=vpa(subs(Sys3.D),50);
Sys3.Y=vpa(subs(Sys3.Y));

Show_Sys(Sys3)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   CONDIZIONI INIZIALI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Wc_0 = 0*0.1*rad/secondo;                % Velocit iniziale solare
Wsc_0= -0*0.2*rad/secondo;               % Velocit iniziale portasatelliti
Wr_0 = Sys1.C(3,:)*[Wc_0; Wsc_0];      % Velocit iniziale ring

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   SIMULAZIONE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


hh=1;
%for ij=[1:11]
for ij=[ 4]
    if ij==10
        CompAi=zeros(1,Nmax+1);
        CompAi(m-6+1)=1;
    end
    if ij==11
        CompAi=zeros(1,Nmax+1);
        CompAi(m-4+1)=1;
    end
    if ij==12
        CompAi=zeros(1,Nmax+1);
        CompAi(m-2+1)=1;
    end
    Tipo=eval(Flusso(ij).Tipo);
    n=[1:2:m-2];
    An=Flusso_Rotorico_An(Tipo,n);
    Ktau0= zeros(m,1);             %%% Matrix Ktau0 
    for k=[1:2:m-2]
        Ktau0(k+1)= k*An((k+1)/2);
    end
    if Star        %%% Reduction of the system matrices if Star is True
        Ktau0=Ktau0([1:m-1]);
    end
    Ktau0=-Phic*p*sqrt(m/2)*Ktau0;
    wI0=Tau_d*Ktau0/norm(Ktau0)^2;
    wV0=MR*wI0+Jr*(Wr_d*Kr.*(MLb*wI0))+Ktau0*Wr_d; %azione feed-forward
end       
    

    Iw0= 0*wI0;               % Inductance currents (rotating frame)
    Wm0 = 0*Wr_d;             % Motor velocity
    Thm0 = 0;               % Motor angular position


Tc=0.05*ms;                            % Switching period
Tfin=0.5*secondo;                      % Durata simulazione
Ts=Tfin/2000;

%return
sim('architetture_epicicloidale_mdl',Tfin);    % Simulazione epicicloidale 

Lw=1.5;
figure(1)
clf
plot(t,W_c,'b','LineWidth',Lw)
hold on
plot(t,Wm,'r','LineWidth',Lw)
title('Velocit del solare')
ylabel('W_c [rad/s]')
xlabel('Time [s]')
zoom on
grid on

figure(2)
clf
plot(t,W_sc,'b','LineWidth',Lw)
hold on
title('Velocit del portasatelliti')
ylabel('W_{sc} [rad/s]')
xlabel('Time [s]')
zoom on
grid on

figure(3)
clf
plot(t,W_r,'b','LineWidth',Lw)
hold on
title('Velocit del ring')
ylabel('W_r [rad/s]')
xlabel('Time [s]')

zoom on
grid on

figure(4)
clf
plot(t,Tm,'b','LineWidth',Lw)
hold on
title('Coppia fornita dal motore elettrico')
ylabel('T_m [Nm]')
xlabel('Time [s]')

zoom on
grid on

