% function OK=Verifica_Sys(Sys)
%
% Questa funzione esegue una serie accurata di verifiche sul sistema che
% viene passato dall'utente
%

function OK=Verifica_Sys(Sys)

OK=1;

[nrL ncL]=size(Sys.L);
[nrB ncB]=size(Sys.B);
[nrC ncC]=size(Sys.C);
[nrD ncD]=size(Sys.D);              % Definisco le righe e le colonne di 
[nrX ncX]=size(Sys.X);              %      ci che mi interessa.
[nrU ncU]=size(Sys.U);
[nrY ncY]=size(Sys.Y);


if nrL~=ncL;    OK=0;    disp('Dimensioni non corrette della matrice L'); end
if nrL~=nrB;    OK=0;    disp('Numero righe non compatibili delle matrici L e B'); end
if ncL~=ncC;    OK=0;    disp('Numero colonne non compatibili delle matrici L e C'); end
if ncX~=1;      OK=0;    disp('La variabile X non  un vettore'); end
if ncU~=1;      OK=0;    disp('La variabile U non  un vettore'); end
if ncY~=1;      OK=0;    disp('La variabile Y non  un vettore'); end
if nrU~=nrY;    OK=0;    disp('I vettori U e Y non sono compatibili'); end
if nrU~=ncB;    OK=0;    disp('Il vettore U non  compatibile con la matrice B'); end
if nrU~=ncD;    OK=0;    disp('Il vettore U non  compatibile con la matrice D'); end
if nrY~=nrC;    OK=0;    disp('Il vettore Y non  compatibile con la matrice C'); end
if nrY~=nrD;    OK=0;    disp('Il vettore Y non  compatibile con la matrice D'); end
if Xi_Tutti_Diversi(Sys.X)==0; OK=0; disp('Il vettore X ha alcuni elementi uguali'); end
if Xi_Tutti_Diversi(Sys.Y)==0; OK=0; disp('Il vettore Y ha alcuni elementi uguali'); end
if Xi_Tutti_Diversi(Sys.U)==0; OK=0; disp('Il vettore U ha alcuni elementi uguali'); end

return