%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% T = T_b_Concordia_Sincrono(m)
%
% Trasformazione di coordinate di tipo "Concordia" di ordine m.
% Utile nello studio dei motori elettrici polifasi.
%
% Author: Zanasi Roberto 
% e-mail: roberto.zanasi@unimore.it
% Date: 10 may 2007
%
% Please, keep "reserved" this file
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function T = T_b_Concordia_Sincrono(m)

if rem(m,2)==0
    disp(['Warning (T_b_Concordia_Sincrono): m = ' num2str(m) '  pari']) 
end
T = ones(m)/sqrt(2);
w = 2*pi/m;
for k = [1:2:m-2]
    for h = [0:m-1]
        T(h+1,k  ) = cos(h*k*w);
        T(h+1,k+1) = sin(h*k*w);
    end
end
T=sqrt(2/m)*T;

return