%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% T = T_b_Concordia(m)
%
% Trasformazione di coordinate di tipo "Concordia" di ordine m.
% Utile nello studio dei motori elettrici polifasi.
%
% Author: Zanasi Roberto 
% e-mail: roberto.zanasi@unimo.it
% Date: 10 may 2007
%
% Please, keep "reserved" this file
% 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function T = T_b_Concordia(m)

  T = ones(m);
  w = 2*pi/m;
  for i = [1:m/2]
      for j = [0:m-1]
          T(j+1,2*i-1) = cos((2*i-1)*w*j     );
          T(j+1,2*i  ) = cos((2*i-1)*w*j+pi/2);
      end
  end
  for i = [1:m]
          T(:, i) = T(:, i)/norm(T(:, i));
  end


return