% function SysT1=Separa_Sys(Sys,nr_in)
%
% Questa funzione separa le matrici B, C, D e i vettori U e Y nelle loro
% rispettive componenti [Bi Bu], [Ci; Cu], [Dii Diu; Dui Duu], [Ui;Uu],
% [Yi; Yu]. 
% 

function SysT=Separa_Sys(Sys,nr_in)

ncB=size(Sys.B,2);             % Numero di colonne di B
ind_i=[1:nr_in];               % ind_i va dalla prima colonna a ncBi
ind_u=[nr_in+1:ncB];           % ind_u va da ind_i+1 all' ultima colonna 
SysT.L=Sys.L;
SysT.mA=Sys.mA;               % Questi 3 non subiscono separazioni
SysT.X=Sys.X;
SysT.Bi=Sys.B(:,ind_i);
SysT.Bu=Sys.B(:,ind_u);
SysT.Ci=Sys.C(ind_i,:);
SysT.Cu=Sys.C(ind_u,:);       % Scorporo le varie matrici\vettori
SysT.Yi=Sys.Y(ind_i,:);
SysT.Yu=Sys.Y(ind_u,:);
SysT.Ui=Sys.U(ind_i,:);
SysT.Uu=Sys.U(ind_u,:);
SysT.Dii=Sys.D(ind_i,ind_i);
SysT.Dui=Sys.D(ind_i,ind_u);
SysT.Diu=Sys.D(ind_u,ind_i);
SysT.Duu=Sys.D(ind_u,ind_u);

return