% function  [SysT T]=Riduci_Sys(Sys,Parametri,Variabili)   
%  
% Questa funzione riduce il sistema di partenza "Sys" in un nuovo sistema  
% "SysT" piu' semplice e compatto.
% Vengono passati i "Parametri" che si vogliono mandare a 0 
% e le "Variabili" che si intendono salvare dalla riduzione.
% In uscita viene restituita  anche la matrice di trasformazione "T".

function  [SysT T]=Riduci_Sys(Sys,Parametri,Variabili)   

ncP=size(Parametri,2);
if ncP>1                        
    Parametri=Parametri.';       
end
                                % Controllo se sono vettori colonna,
ncV=size(Variabili,2);          %  se non lo sono li trasformo io.
if ncV>1
    Variabili=Variabili.';
end
    
nrP=length(Parametri);            % Dimensione del vettore Parametri
nrV=length(Variabili);            % Dimensione del vettore Variabili
nrX=size(Sys.X,1);                % Dimensione del vettore X


if Sys.L~=Sys.L.'
    disp('L non  simmetrica');   % Controllo se L e' simmetrica 
    return
end
for p=1:length(Parametri)
    if (ismember(diag(Sys.L),Parametri(p))==0)
        disp('Warning: un parametro non  presente nella matrice L');
    end
end

X0=zeros(nrX,1);
T=[];
for ii=[1:nrV]
    k=ismember(Sys.X,Variabili(ii));
    if (max(k)==1)                      % Costruisco la matrice T
      T=[T k];                          % e un vettore X0 con degli 1 
      X0=X0+k;                          % dove ho trovato le variabili.
    end
end
ind=find(X0==0);
En=eye(nrX);
T1=[T En(:,ind)];                       % Completo la matrice T con le  
                                        % colonne della matrice identita'
                                        % di indice corrispondente agli 0 
                                        % nel vettore X0.
                                          
SysT=Trasforma_Sys(Sys,T1);             % Applico le formule di riduzione

for ii=[1:nrP]
    if numden(Parametri(ii))==1
        new_el=1/Parametri(ii);         % Faccio il reciproco del parametro
        SysT.L=limit(SysT.L,new_el,inf);         % Faccio il limite per    
                                                 % new_el -> inf
    else
        SysT.L=limit(SysT.L,Parametri(ii),0);    % Faccio il limite per 
    end                                          % parametri -> 0
end
Ker=null(SysT.L);              % Cerco gli autovettori tali per cui L*Ker=0
ncK=size(Ker,2);               % Colonne della matrice Ker

X0=sum(Ker,2);                 % Costruisco la matrice T portando le
ind=find(X0==0);               % colonne di nome Ker alla fine per avere      
En=eye(nrX);                   % gli elementi che voglio azzerare in fondo 
T2=[En(:,ind) Ker];            % alle varie matrici.
                                         
SysT=Trasforma_Sys(SysT,T2);            % Applico le formule di riduzione

rango=zeros(1,nrX+1);                   % Inizializzo il vettore rango
jj=nrX+1;                               % Parto una colonna dopo per 
                                        % entrare nel ciclo con rango=0.
while rango(jj)<ncK
    jj=jj-1;                             % Calcolo il rango partendo
    A=SysT.mA([nrX-ncK+1:nrX],[jj:nrX]); % dall'ultima colonna fino a 
    rango(jj)=rank(A);                   % quando non arrivo a ncK colonne  
end                                      % linearmente indipendenti tra le 
                                         % ultime ncK righe. 

rango=rango(1:nrX);

ind1=find(rango(1:nrX-ncK)==0);            % Cerco gli elementi del vettore 
nrXT=length(ind1);                         % rango che sono nulli e non tra  
ind2=find(rango~=0);                       % la prima e la nrX-ncK-esima 
ind3=nrX-ncK+find(rango(nrX-ncK+1:nrX)==0);% colonna, e quelli nulli dalla 
nrK0=length(ind3);                         % nrX-ncK+1-esima all'ultima 
En=eye(nrX);                               % colonna per poter costruire 
T3=[En(:,ind1) En(:,ind2) En(:,ind3)];     % la matrice T3 la quale  
                                           % riordina le matrici in modo
                        % che: 1)possano essere distinti gli elementi che
                        % sicuramente saranno eliminati (quelli di indice
                        % ind3), 2)si possa individuare la matrice
                        % invertibile che mi consente di scrivere quelle 
                        % variabili in funzione delle altre (quella con
                        % ind2), 3)si possa individuare la matrice che 
                        % moltiplica le variabili che voglio salvare (ind1)
                        
SysT=Trasforma_Sys(SysT,T3);              % Applico le formule di riduzione


A31 = SysT.mA([nrX-ncK+1:nrX],[1:nrXT]);              % Creo la matrice 3)
A32 = SysT.mA([nrX-ncK+1:nrX],nrXT+[1:ncK]);          % Creo la matrice 2)
AX21 = simplify(-inv(A32)*A31);
T4 = simplify([eye(nrXT); AX21; zeros(nrK0,nrXT)]);   % Creo la matrice T4

SysT=Trasforma_Sys(SysT,T4);              % Applico le formule di riduzione

T=simplify(T1*T2*T3*T4);                            % Calcolo la T complessiva

return