clear all
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE UNITA' DI MISURA DEL SISTEMA INTERNAZIONALE (SI)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
metri = 1; dm = 0.1*metri; cm = 0.01*metri; mm = 0.001*metri; km = 1000*metri;
kg = 1;
N = 1;
kN = 1000*N;
secondo = 1; ora = 60*60*secondo;  minuti = 60*secondo;
ms = 0.001*secondo;
Pa = 1;
rad = 1;
gradi =( pi/180)*rad;
bar = 10^5*Pa;
lt = 0.001*metri^3;
rpm = 2*pi/60*rad/secondo;
g = 9.8*metri/secondo^2;
Volt=1; Amp=1; Ohm=Volt/Amp;
Henry=Volt*secondo/Amp; Weber=Volt*secondo;
Si=true; Yes=true; No=false;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%    DEFINIZIONE PARAMETRI DEL MOTORE ELETTRICO     %%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  Flusso rotorico: parte magnetica del motore
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%%% Tipi di flusso rotorico 

Flusso(1)=struct('Nome','Trapezoidale', ...
                 'Tipo','[1,pi/4]', ...
                 'Simbolo','Phit(al,th)');
Flusso(2)=struct('Nome','Triangolare', ...
                 'Tipo','[1, 0]', ...
                 'Simbolo','Phi1(th)');
Flusso(3)=struct('Nome','Ad_onda_quadra', ...
                 'Tipo','[2]', ...
                 'Simbolo','Phi0(th)');
Flusso(4)=struct('Nome','Sinusoidale', ...
                 'Tipo','[3]', ...
                 'Simbolo','Cos(th)');
Flusso(5)=struct('Nome','Raccordo_cosinusoidale', ...
                 'Tipo','[4,pi/4]', ...
                 'Simbolo','Phic(al,th)');
Flusso(6)=struct('Nome','Raccordo_sinusoidale', ...
                 'Tipo','[5,pi/8]', ...
                 'Simbolo','Phis(al,th)');
Flusso(7)=struct('Nome','Polinomiale_pari', ...
                 'Tipo','[6,0.5*pi/8,6]', ...
                 'Simbolo','Phiq(al,th)');
Flusso(8)=struct('Nome','Polinomiale_dispari', ...
                 'Tipo','[7,3*pi/8,9]', ...
                 'Simbolo','Phir(al,th)');
Flusso(9)=struct('Nome','Derivata_trapezoidale', ...
                 'Tipo','[8,pi/4]', ...
                 'Simbolo','Phid(al,th)');
Flusso(10)=struct('Nome','Definito_dallo_spettro', ...
                 'Tipo','[9,Nmax,CompAi]', ...
                 'Simbolo','Spettro');
Flusso(11)=struct('Nome','Definito_dallo_spettro', ...
                 'Tipo','[9,Nmax,CompAi]', ...
                 'Simbolo','Spettro');
Flusso(12)=struct('Nome','Definito_dallo_spettro', ...
                 'Tipo','[9,Nmax,CompAi]', ...
                 'Simbolo','Spettro');

   

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  Electric parameters of the motor
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
m=5;                    % Nr of motor phases
p=1;                    % Nr of polar expansion
Nar=200;                % Nr of harmonics in the Fourier series
%
Nc=30;                 % Number of coils for each phase (p=1)
Li=0.1*Henry;           % i-th self inductance coefficient (p=1)
Mi=0.08*Henry;          % ij-th mutual inductance coefficient (p=1)
Ri=3*Ohm;               % i-th resistance (p=1)
Star=Si;               % Are the inductances "star-connected"? [Yes, No]
%
Jm=0.3*1.6*kg*metri^2;      % Rotor inertia momentum
bm=0.8*N*metri*secondo/rad;      % Rotor linear friction coefficient
%
Phir = 5*0.02*Weber;      % Maximum value of the rotor flux
Nmax=m;

%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% Ingressi del sistema
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
Vmax=100*Volt;                      % Tensione massima in ingresso
V_in    = Vmax*ones(1,m)';          % Ampiezze
Phi_in  = pi/2 -2*pi*[0:m-1]'/m ;   % Fasi
Freq_in = 3*2*pi;                   % Pulsazione
Ce=0;                               % Coppia resistente
Tau_d=50*N*metri;                   % Coppia desiderata
Wr_d=(Tau_d-Ce)/bm;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% tTb=T_b_Concordia_Sincrono(m);       %%% Trasformazione "T(b->t)": matrice tTb;

tTb = ones(m)/sqrt(2);
w = 2*pi/m;
for k = [1:2:m-2]
    for h = [0:m-1]
        tTb(h+1,k  ) = cos(h*k*w);
        tTb(h+1,k+1) = sin(h*k*w);
    end
end
tTb=sqrt(2/m)*tTb;    

%%%%%% Trasformazione "T(b->w)": matrici I_m, MKr e Jr;
I_m = eye(m);
MKr = zeros(m);              
Jr  = zeros(m);
for k=[1:2:m-1]
    MKr(k,k ) = k;  MKr(k+1,k+1) = k;
    Jr(k+1,k) = 1;  Jr(k,k+1) = -1;  
end

MLb=p*eye(m)*(Li-Mi);       %%% Auto and mutual inductance matrix MLb 
MLb(1,1)=p*(Li+(m-2)*Mi/2); %%% defined in the rotating frame
MLb(2,2)=p*(Li+(m-2)*Mi/2);

MR = p*Ri*eye(m);           %%% Resistance matrice MR defined in the rotating frame
%
Kr= zeros(m,1);             %%% Matrix Kr for the energy redistribution "j*w*L"
for j=[1:2:m-1]
    Kr(j)= j;  Kr(j+1)= j;
end
%
Phic = p*Nc*Phir;           %%% Maximum value of the concatenated flux;
%
%
if Star        %%% Reduction of the system matrices if Star is True
    tTb=tTb(:,[1:m-1]);
    MKr=MKr([1:m-1],[1:m-1]);
    Jr=Jr([1:m-1],[1:m-1]);
    I_m=eye(m-1);
    MLb=MLb([1:m-1],[1:m-1]);
    MR=MR([1:m-1],[1:m-1]);
    Kr=Kr([1:m-1]);
end


   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   SEGNALI ESTERNI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Ts_0=0*N*metri;                          % Coppia al portasatelliti
Tc_0=0*N*metri;                           % Coppia al solare
Tr_0=0*N*metri;                           % Coppia al ring

W_c=100*rpm;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   CONDIZIONI INIZIALI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Wc_0 = 0*0.1*rad/secondo;                % Velocit iniziale solare
Wsc_0= -0*0.2*rad/secondo;               % Velocit iniziale portasatelliti
%Wr_0 = Sys1.C(3,:)*[Wc_0; Wsc_0];      % Velocit iniziale ring

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   REGOLATORE PI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Kprop=32.3;
Tint=0.2427;
Tder=0.0119*20;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   SIMULAZIONE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


hh=1;
%for ij=[1:11]
for ij=[ 4]
    if ij==10
        CompAi=zeros(1,Nmax+1);
        CompAi(m-6+1)=1;
    end
    if ij==11
        CompAi=zeros(1,Nmax+1);
        CompAi(m-4+1)=1;
    end
    if ij==12
        CompAi=zeros(1,Nmax+1);
        CompAi(m-2+1)=1;
    end
    Tipo=eval(Flusso(ij).Tipo);
    n=[1:2:m-2];
    An=Flusso_Rotorico_An(Tipo,n);
    Ktau0= zeros(m,1);             %%% Matrix Ktau0 
    for k=[1:2:m-2]
        Ktau0(k+1)= k*An((k+1)/2);
    end
    if Star        %%% Reduction of the system matrices if Star is True
        Ktau0=Ktau0([1:m-1]);
    end
    Ktau0=Phic*p*sqrt(m/2)*Ktau0;
    wI0=Tau_d*Ktau0/norm(Ktau0)^2;
    wV0=MR*wI0+Jr*(Wr_d*Kr.*(MLb*wI0))+Ktau0*Wr_d; %azione feed-forward
end       
    

    Iw0= 0*wI0;               % Inductance currents (rotating frame)
    Wm0 = 0*Wr_d;             % Motor velocity
    Thm0 = 0;               % Motor angular position
    
    tau_m=[0.05:0.04:1];
    %    Kf=0*eye(m-1);              % gain of proportional regulator
    Kf=diag(diag(MLb)'./fliplr(tau_m(1:m-1)));      % gain of proportional regulator

    

Tc=0.05*ms;                            % Switching period
Tfin=8*secondo;                      % Durata simulazione
Ts=Tfin/2000;

T_in=[0 1 3 4.5 7 8]';               % Time vector
w_des=[0 0 20 20 0 0]';     % Desired torque input vector

% return
sim('PMSM_controllo_w_mdl',Tfin);    % Simulazione epicicloidale 

Lw=1.5;
figure(1)
clf
plot(t,Wm,'b','LineWidth',Lw)
hold on
plot(T_in,w_des,'r--','LineWidth',Lw)
title('Velocit del motore elettrico')
ylabel('W_m [rad/s]')
xlabel('Time [s]')
zoom on
grid on


figure(2)
clf
plot(t,Tm,'b','LineWidth',Lw)
hold on
plot(t,Tref,'r--','LineWidth',Lw)
title('Coppia fornita dal motore elettrico')
ylabel('T_m [Nm]')
xlabel('Time [s]')
zoom on
grid on


