clear all
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DEFINIZIONE DELLE UNITA' DI MISURA DEL SISTEMA INTERNAZIONALE (SI)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
m = 1; cm = 0.01*m; mm = 0.001*m; km = 1000*m;
kg = 1;
N = 1;
kN = 1000*N;
secondo = 1; ora = 60*60*secondo;  minuti = 60*secondo;
ms = 0.001*secondo;
Pa = 1;
rad = 1;
gradi =( pi/180)*rad;
bar = 10^5*Pa;
lt = 0.001*m^3;
rpm = 2*pi/60*rad/secondo;
g = 9.8*m/secondo^2;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DATI DEI PNEUMATICI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tabDryFX=10*[-2500 -2620 -2740 -2860 -2980 -3100 -3220 -3340 -3420 -3500 -3530 -3450 -3350 -3000 -2600 -1850 -1000 0 1000 1850 2600 3000 3350 3450 3530 3500 3420 3340 3220 3100 2980 2860 2740 2620 2500 ]';

slip1=[-0.7 -0.6 -0.5 -0.45 -0.4 -0.35 -0.3 -0.25 -0.2 -0.16 -0.14 -0.12 -0.1 -0.08 -0.06 -0.04 -0.02 0 0.02 0.04 0.06 0.08 0.1 0.12 0.14 0.16 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.6 0.7];

vetSLIPDry=[-0.7 -0.6 -0.5 -0.45 -0.4 -0.35 -0.3 -0.25 -0.2 -0.16 -0.14 -0.12 -0.1 -0.08 -0.06 -0.04 -0.02 0 0.02 0.04 0.06 0.08 0.1 0.12 0.14 0.16 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.6 0.7]';
%vetSLIPDry=vetSLIPDry+vetSLIPDry*0.2;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DATI DEL VEICOLO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Mv=4000*kg;            %Massa del mezzo
Rr=0.905*m;            %Raggio della ruota
Vx_00=0.0000001;       %Velocit

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rho_acc=7.5;         % Densit dell'acciaio 
kb=100;              % Coefficiente di proporzionalit tra il coefficiente
                     % di attrito b e l'inerzia J_m di una ruota

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DEFINIZIONE DELLE VARIABILI STANDARD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PASSO LINEARE DEI DENTI
xd=2*cm;
xdm=xd;
xdp=xd;
xdq=xd;
xdr=xd;
xds=xd;
xd0=xd;
%%% SPESSORE DELLE RUOTE DENTATE (LARGHEZZA DEI DENTI)
hm=3*cm;
hp=3*cm;
hq=3*cm;
hr=3*cm;
hs=3*cm;
h0=3*cm;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DEFINIZIONE DELLE CARATTERISTICHE FISICHE DEL SISTEMA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%
%%%% Routa "m" connessa al motore endotermico
Nm=40;
r_m=xdm*Nm/(2*pi);
J_m=1.2*pi*hm*rho_acc*r_m^4/2;
b_m=kb*J_m;
%%%%
%%%% Routa intermedia "n"
Nn1=55;
Nn2=64;
r_n1=xdm*Nn1/(2*pi);
r_n2=xdp*Nn2/(2*pi);
J_n=0.5*pi*rho_acc*(hm*r_n1^4 + hp*r_n2^4);
b_n=kb*J_n;
%%%%
%%%% Routa intermedia "o"
No=36;
r_o=xdp*No/(2*pi);
J_o=0.5*pi*rho_acc*hp*r_o^4;
b_o=kb*J_o;
%%%%
%%%% Routa "p" connessa alla pompa idraulica
Np=33;
r_p=xdp*Np/(2*pi);
J_p=0.5*pi*rho_acc*hp*r_p^4;
b_p=kb*J_p;
%%%%
%%%% Routa "q" connessa al motore idraulico
Nq=42;
r_q=xdq*Nq/(2*pi);
J_q=0.5*pi*rho_acc*hq*r_q^4;
b_q=kb*J_q;
%%%%
%%%% Routa intermedia "t"
Nt1=43;
Nt2=36;
r_t1=xdq*Nt1/(2*pi);
r_t2=xdr*Nt2/(2*pi);
J_t=0.5*pi*rho_acc*(hq*r_t1^4 + hr*r_t2^4);
b_t=kb*J_t;
%%%%
%%%% Routa "r" Ring gruppo epicicloidale
Nr1=78;
Nr2=78;
h_ring=9*cm; 
diff_r=1.2*cm;      %%%% Differenza tra raggio interno e raggio esterno ring
r_r1=xdr*Nr1/(2*pi);
r_ri=xds*Nr2/(2*pi);
r_re=r_ri+diff_r;
J_r=0.5*pi*rho_acc*(hr*r_r1^4 + h_ring*(r_re^4-r_ri^4));
b_r=kb*J_r;
%%%%
%%%% Routa "s" Satellite gruppo epicicloidale
Ns1=28;
Ns2=18;
r_s1=xds*Ns1/(2*pi);
r_s2=xd0*Ns2/(2*pi);
Nr_Sat=4;                   % Numero dei satelliti
J_s=Nr_Sat*0.5*pi*rho_acc*(hs*r_s1^4 + h0*r_s2^4);
b_s=kb*J_s;
%%%%
%%%% Routa "u" Solare (1) gruppo epicicloidale
Nu=21;
r_u=xds*Nu/(2*pi);
J_u=1.5*0.5*pi*rho_acc*hs*r_u^4;
b_u=kb*J_u;
%%%%
%%%% Routa "0" Solare (2) gruppo epicicloidale
N0=30;
r_0=xd0*N0/(2*pi);
J_0=1.3*0.5*pi*rho_acc*h0*r_0^4;
b_0=kb*J_0;
%%%%
%%%% Routa "s0" Satelliti-solare gruppo epicicloidale + massa veicolo
J_s0=Nr_Sat*(r_0+r_s2)^2*rho_acc*pi*(hs*r_s1^2 + h0*r_s2^2); %+Mv/4*(Rr)^2;
b_s0=kb*J_s0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SEMPLIFICAZIONE DEL SISTEMA (RIDUZIONE NUMERO RUOTE DENTATE)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%
%%%% Routa "m + n" connessa al motore endotermico
J_mn=J_m+J_n*(Nm/Nn1)^2;
b_mn=b_m+b_n*(Nm/Nn1)^2;
r_mn=(Nm/Nn1)*r_n2;
%%%%
%%%% Routa "o + p" connessa alla pompa idraulica
J_op=J_p+J_o*(Np/No)^2;
b_op=b_p+b_o*(Np/No)^2;
r_op=(Np/No)*r_o;
%%%%
%%%% Routa "q + t" connessa al motore idraulica
J_qt=J_q+J_t*(Nq/Nt1)^2;
b_qt=b_q+b_t*(Nq/Nt1)^2;
r_qt=(Nq/Nt1)*r_t2;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PARAMETRI IDRAULICI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C_pq=1e-14*m^3/Pa;                   %1e-14*m^3/Pa
R_p=0.8*(30*bar)/(400*lt/minuti);    %0.8*(30*bar)/(400*lt/minuti)
R_q=0.8*(30*bar)/(400*lt/minuti);    %0.8*(30*bar)/(400*lt/minuti)

Hq=(400*lt/minuti)/(3400*rpm);      %(200*lt/minuti)/(2000*rpm)
Hp_max=Hq;
Th_max=45*gradi;                    % Angolazione massima del piattello
Th_0=25*gradi;                      % Angolazione del piattello attuale

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PARAMETRI MATRICIALI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Rs0=[-r_s2;r_0]; 

JJs0=diag([J_s,J_s0]);

Bs0=diag([b_s,b_s0]);

Rsr=[r_s1 r_ri];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PARAMETRI ELASTICI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
K0=1000000;   % per simulazioni con carico K0=10000;
d0=10;

K_m0=K0;
d_m0=d0;

K_0s=K0;
d_0s=d0;

K_sr=K0;
d_sr=d0;

K_pm=K0;
d_pm=d0;

K_qr=K0;
d_qr=d0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SEGNALI ESTERNI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Tem=440*N*m;                    % Coppia motore
Tes0=-0*(N0+Nr1)/N0*Tem*N*m;    % Coppia alla ruota
Tes=0*N*m;                      % Coppia ai satelliti
T0=0;                           % Coppia al solare
Tr=0;                           % Coppia al ring
Top=0;                          % Coppia alla pompa idraulica
Tqt=0;                          % Coppia al motore idraulico


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%  CIRCUITO RIDOTTO  %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


SysS=Calcola_CVT;

Show_Sys(SysS)

Sys=SysS;

J_theta=vpa(subs(Sys.L),50);
b_theta=-vpa(subs(Sys.A),50);

Rap_Tras=vpa(subs(Sys.Yi(4)/Sys.Yi(2)),50);

Hp_th=Hp_max*sin(Th_0)/sin(Th_max);

Sys.L=vpa(subs(Sys.L),50);
Sys.A=vpa(subs(Sys.A),50);
Sys.Bi=vpa(subs(Sys.Bi),50);
Sys.Bu=vpa(subs(Sys.Bu),50);
Sys.Ci=vpa(subs(Sys.Ci),50);
Sys.Cu=vpa(subs(Sys.Cu),50);
Sys.Dii=0;
Sys.Diu=0;
Sys.Dui=0;
Sys.Duu=0;
Sys.Yi=vpa(subs(Sys.Yi),50);
Sys.Yu=vpa(subs(Sys.Yu),50);
SysN=Sys;

Show_Sys(SysN)

Jt_th=double(SysN.L);
bt_th=-double(SysN.A);

Tt=double(SysN.Ci);

Tw=[Tem T0 Tes Tes0 Tr Top Tqt];


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CONDIZIONI INIZIALI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Wm_0 =1*rpm;          % Velocit albero motore (100*rpm con carico)
WW_0 =Tt*Wm_0;
W0_0 =WW_0(2),        % Velocit albero "solare"
ws_0 =WW_0(3),        
ws0_0=WW_0(4),        
Wr_0 =WW_0(5),        % Velocit albero "ring"
Wp_0 =WW_0(6),        % Velocit albero "pompa"
Wq_0 =WW_0(7),        % Velocit albero "motore idraulico"

Ws0_0=[ws_0;ws0_0];   % Velocit di rotazione e rivoluzione dei satelliti
Vx_0=ws0_0*Rr;        % Velocit del mezzo

Ppq_0=0;              % Pressione

%return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MOMENTO D'INERZIA EQUIVALENTE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Jt_th = J0+Jmn+(Jop*rmn^2)/(rop^2)+(hp^2*Jqt*rmn^2)/(hq^2*rop^2)+...
% (hp^2*Jr*rmn^2*rqt^2)/(hq^2*rop^2*rr1^2)+(Js0*(hq*r0*rop*rr1*rs2-...
% hp*rmn*rqt*rri*rs2)^2)/(hq*r0*rop*rr1*rs1+hq*rop*rr1*rri*rs2)^2+(Js*...
% (hp*r0*rmn*rqt*rri+hq*r0*rop*rr1*rri)^2)/(-hq*r0*rop*rr1*rs1-...
% hq*rop*rr1*rri*rs2)^2;
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% COEFFICIENTE D'ATTRITO EQUIVALENTE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% bt_th = (bs*r0^2*(hp*rmn*rqt+hq*rop*rr1)^2*rri^2+r0^2*(br*hp^2*rmn^2*...
% rqt^2+(bqt*hp^2*rmn^2+hq^2*((b0+bmn+bs0)*rop^2+rmn^2*(bop+hp^2*(Rp+Rq)))+...
% 4*dqr*hp^2*rmn^2*rqt^2)*rr1^2)*rs1^2+2*r0*(br*hp^2*rmn^2*rqt^2-bs0*hp*hq*...
% rmn*rop*rqt*rr1+(bqt*hp^2*rmn+hq^2*((b0+bmn)*rop^2+rmn^2*(bop+hp^2*(Rp+Rq)))+...
% 4*dqr*hp^2*rmn^2*rqt^2)*rr1^2)*rri*rs1*rs2+((br+bs0)*hp^2*rmn^2*rqt^2+...
% (bqt*hp^2*rmn^2+hq^2*((b0+bmn)*rop^2+rmn^2*(bop+hp^2*(Rp+Rq)))+4*dqr*hp^2*...
% rmn^2*rqt^2)*rr1^2)*rri^2*rs2^2)/(hq^2*rop^2*rr1^2*(r0*rs1+rri*rs2)^2);
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SIMULAZIONE SISTEMA RIDOTTO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Tc=0.05*ms;         %%%%% Switching period
Tfin=0.1*secondo;
sim('CVT_New_Ridotto_mdl',Tfin);     % Simulazione CVT_Ridotto

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% GRAFICAZIONE SISTEMA RIDOTTO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(1)
clf
plot(t,Xt/rpm,'LineWidth',2)
ylabel('Wm W0 Ws Ws0 Wr Wp Wq [rpm]')
zoom on
grid on

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SIMULAZIONE GENERALE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Tc=0.05*ms;         %%%%% Switching period
Tfin=0.1*secondo;
sim('CVT_New_mdl',Tfin);             % Simulazione CVT

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% GRAFICAZIONE CONFRONTO SISTEMI
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(10)
clf
plot(t,Wm/rpm,'b--','LineWidth',1)
hold on
plot(t,W0/rpm,'g--','LineWidth',1)
plot(t,Ws0(:,1)/rpm,'r--','LineWidth',1)
plot(t,Ws0(:,2)/rpm,'c--','LineWidth',1)
plot(t,Wr/rpm,'m--','LineWidth',1)
plot(t,Wp/rpm,'y--','LineWidth',1)
plot(t,Wq/rpm,'k--','LineWidth',1)

plot(t,Xt(:,1)/rpm,'b','LineWidth',1)
plot(t,Xt(:,2)/rpm,'g','LineWidth',1)
plot(t,Xt(:,3)/rpm,'r','LineWidth',1)
plot(t,Xt(:,4)/rpm,'c','LineWidth',1)
plot(t,Xt(:,5)/rpm,'m','LineWidth',1)
plot(t,Xt(:,6)/rpm,'y','LineWidth',1)
plot(t,Xt(:,7)/rpm,'k','LineWidth',1)
ylabel('Wm W0 Ws Ws0 Wr Wp Wq [rpm]')
zoom on
grid on

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%%%%%% PER LA SIMULAZIONE CON CARICO, UNCOMMENT QUELLO CHE SEGUE %%%%%%%%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % SIMULAZIONE GENERALE CON CARICO
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% Tc=0.05*ms;         %%%%% Switching period
% Tfin=0.1*secondo;
% sim('CVT_New_Carico_mdl',Tfin);             % Simulazione CVT
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % GRAFICAZIONE SISTEMA GENERALE CON CARICO
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% figure(6)
% clf
% subplot(211)
% plot(t,[Wp Wm W0]/rpm,'LineWidth',2)
% ylabel('Wp, Wm, W0 [rpm]')
% zoom on
% grid on
% %
% subplot(212)
% plot(t,[Wq Wr]/rpm,'LineWidth',2)
% ylabel('Wq Wr[rpm]')
% xlabel('Time [s]')
% zoom on
% grid on
% 
% figure(7)
% clf
% subplot(211)
% plot(t,[Ws0(:,1) Ws0(:,2)]/rpm,'LineWidth',2)
% ylabel('Ws, Ws0 [rpm]')
% zoom on
% grid on
% %
% subplot(212)
% plot(t,[Wr Ws0(:,1) Ws0(:,2) W0]/rpm,'LineWidth',2)
% ylabel('Wr, Ws0, Ws, W0 [rpm]')
% xlabel('Time [s]')
% zoom on
% grid on
% 
% figure(8)
% clf
% subplot(211)
% plot(t,Ppq/bar,'LineWidth',2)
% ylabel('Ppq [bar]')
% zoom on
% grid on
% %
% subplot(212)
% plot(t,Vx/(km/ora),'LineWidth',2)
% ylabel('Vx [km/ora]')
% xlabel('Time [s]')
% zoom on
% grid on
% 
% figure(9)
% clf
% subplot(211)
% plot(t,Fx,'LineWidth',2)
% ylabel('Fx [N]')
% zoom on
% grid on
% %
% subplot(212)
% plot(t,Slip,'LineWidth',2)
% ylabel('Slip [m/s]')
% xlabel('Time [s]')
% zoom on
% grid on
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

syms Thd_0

Thd_max=Th_max/gradi;          

Hp_th=Hp_max*sin(Thd_0*gradi)/sin(Thd_max*gradi);  % Variazione porta,
                                                   % andamento sinusoidale

J_theta=vpa(subs(J_theta),50);
b_theta=vpa(subs(b_theta),50);
Rap_Tras=vpa(subs(Rap_Tras),50);
tau_theta=J_theta/b_theta

figure(20)
clf
h=ezplot(J_theta,[-Thd_max,Thd_max]);
set(h,'LineWidth',2)
ylabel('J_theta [s]')
title('Inerzia Equivalente')
grid on

figure(21)
clf
h=ezplot(b_theta,[-Thd_max,Thd_max]);
set(h,'LineWidth',2)
ylabel('b_theta [s]')
title('Attrito Equivalente')
grid on

figure(22)
clf
h=ezplot(tau_theta,[-Thd_max,Thd_max]);
set(h,'LineWidth',2)
ylabel('tau [s]')
title('Rapporto Inerzia/Attrito')
grid on

figure(23)
clf
h=ezplot(Rap_Tras,[-Thd_max,Thd_max]);
set(h,'LineWidth',2)
ylabel('ws0/wm')
title('Rapporto di Trasmissione')
grid on
