function [A,B,C,D]=Analizza_lo_schema(schema)

eV='eV';
eI='eI';
eC='eC';
eL='eL';
eR='eR';

[Sc, maxi]=Crea_lo_schema(schema);
for ii=1:8
    Sc(ii)
end

CM=zeros(maxi);
VM=zeros(maxi);
for ii=1:max(size(Sc))
    CM(Sc(ii).From,Sc(ii).To)=1;
    CM(Sc(ii).To,Sc(ii).From)=1;
    if (Sc(ii).Tipo==eV)|(Sc(ii).Tipo==eC)
        VM(Sc(ii).From,Sc(ii).To)=1;
        VM(Sc(ii).To,Sc(ii).From)=1;
    end
end
CM
VM
v0=zeros(maxi,1); v1=v0; v2=v0;
v0(maxi)=1;
while norm(v0)>0
    %for ii=1:3
    vnew=VM*v0>0;
    A=[v2 v1 v0 vnew]
    if norm(vnew.*v0)>0
        A=[v2 v1 v0 vnew]
        disp('loop algebrico 1')
        break
    end
    vnew=vnew-vnew.*v1;
    if norm(vnew.*v2)>0
        A=[v2 v1 v0 vnew]
        disp('loop algebrico 2')
        break
    end
    v2=v2+v0; 
    v1=v0; 
    v0=vnew;
end
A=[v2 v1 v0 vnew]
A=0;
B=0;
C=0;
D=0;

return

function [Scr, maxi]=Crea_lo_schema(schema)

maxi=max(max(str2num(schema(:,3:6))))+1;
for ii=1:size(schema,1)
    Tipo=schema(ii,1:2);
    From=str2num(schema(ii,3:4));  if From==0; From=maxi; end;
    To=str2num(schema(ii,5:6));    if To==0; To=maxi; end;
    if  norm(strmatch(Tipo,strvcat('eV','eI','eR','eL','eR','eC'),'exact'))==0
        disp(['Errore! Elemento non definito: ' schema(ii,:)])
        break
    end
    if  (From<0)|(To<0)|(From==To)
        disp(['Errore! Connessione non definita: ' schema(ii,:)])
        break
    end
    if  From<To
        Scr(ii)=struct('Tipo',Tipo,'From',From,'To',To,'Dir',1);
    else
        Scr(ii)=struct('Tipo',Tipo,'From',To,'To',From,'Dir',-1);
    end
end
[S,I]=sort([Scr.From]);
Scr=Scr(I);

return


