%function [SysI inv_S_N]=Inverti_Sys(Sys,elem)
%
%Funzione che inverte l'elemento elem del sistema Sys con il rispettivo
%ingresso o uscita.
%Alla funzione viene passato il vettore di elementi che si vogliono 
%invertire (elem). 
%La funzione tenta di invertire tutti gli elementi passatele, se non riesce
%cerca di invertirne il maggior numero mostrando con messaggi gli elementi
%che  riuscita ad invertire. Se non riesce ad inverire nessun elemento
%resistuisce il sistema non invertito e il flag inv_S_N=0.
%La funzione restituisce il sistema invertito (SysI) e un flag inv_S_N che
%indica se il sistema  inveribile (inv_S_N=1) o no (inv_S_N=0)
%
%
function [SysI inv_S_N]=Inverti_Sys(Sys,elem)

[nr_elem nc_elem]=size(elem);
if nc_elem >nr_elem         %controllo che elem sia un vettore colonna
    elem=elem.';
    [nr_elem nc_elem]=size(elem) ;   
end
if nr_elem>size(Sys.U,1)    %controllo numero elementi da invertire
    disp('Errore: numero eccessivo di elementi da invertire');
    return
end
if Xi_Tutti_Diversi(elem)==0;   %controllo che siano diversi
    disp(' Errore: sono presenti elememti uguali nel vettore di elementi da invertire'); 
    return    
end
Xi=zeros(size(Sys.U,1),1);
Xu=zeros(size(Sys.Y,1),1);
for ii=[1:nr_elem]                  %ciclo per verificare se gli elementi
    ind_i=ismember(Sys.U,elem(ii)); %sono ingressi o uscite
    ind_u=ismember(Sys.Y,elem(ii));
    Xi=Xi+ind_i;
    Xu=Xu+ind_u;
end    
if max(Xi)==0 && max(Xu)==0 %controllo che gli elementi appartengano ai vettori di ingresso o uscita
    disp('Errore:gli elementi inseriti non appartengono ne al vettore di ingresso ne al vettore di uscita');
    return    
end
for ii=[1:nr_elem]
    if (Xi(ii)==1 && Xu(ii)==1) 
        disp('Errore: si vogliono invertire due elementi appartenenti alla stessa porta energetica');
        return
    end
    if Xu(ii)==1
        elem(ii)=Sys.U(ii);
    end
end   
nr_vett=size(Sys.U,1);
vett=Sys.U;

%Routine per crare la trasformazione T che mette in cima al vettore
%vett gli elementi che voglio invertire

for jj=[nr_elem:-1:1]               %cicli che permettono di vagliare tutte 
    C=nchoosek(elem,jj);            %le combinazioni di elementi da invertire.
    for kk=[1:nchoosek(nr_elem,jj)] %Si parte dal numero massimo di elementi e
        vett_t=C(kk,:).';           %si scala di uno alla volta provando tutte
        X0=zeros(nr_vett,1);        %le combinazioni
        T=[];
        for ii=[1:jj]
            k=ismember(vett,vett_t(ii));      % Creo la matrice T da applicare
            if (max(k)==1)                  % al sistema
                T=[T k];
                X0=X0+k;
            else
                disp('Errore:elemento non presente sul vettore U degli ingressi')
                return
            end
        end
        ind=find(X0==0);
        En=eye(nr_vett);
        T=[T En(:,ind)];                      % Completo la matrice T
        SysT=Trasforma_UY_Sys(Sys,T);       % Applico una trasformazione ingresso
                                            % uscita utilizzando la matrice T
                                            % appena creata.
        SysT=Separa_Sysv1(SysT,jj);
        if det(SysT.D11)~=0             %se il sistema  invertibile si appplicano
            inv_S_N=1;                   %le formule viste in teoria e si mette il
            SysI.L=SysT.L;              %controllo inv_S_N a 1.
            SysI.X=SysT.X;
            SysI.mA=SysT.mA-SysT.B1*inv(SysT.D11)*SysT.C1;
            SysI.B=[SysT.B1*inv(SysT.D11) SysT.B2-SysT.B1*inv(SysT.D11)*SysT.D12];
            SysI.C=[-inv(SysT.D11)*SysT.C1;SysT.C2-SysT.D21*inv(SysT.D11)*SysT.C1];
            SysI.D=[inv(SysT.D11) -inv(SysT.D11)*SysT.D12; SysT.D21*inv(SysT.D11) SysT.D22-SysT.D21*inv(SysT.D11)*SysT.D12 ];
            SysI.U=[SysT.Y1;SysT.U2];
            SysI.Y=[SysT.U1;SysT.Y2];
            disp('La funzione ha invertito i seguenti elementi:')
            disp(vett_t)
            return
        else
            disp('Warning: con la seguente combinazione di elementi il sistema non  invertibile:')
            disp(vett_t)
        end
    end
end
inv_S_N=0;               %se non  invertibile si avverte l'utente e si
SysI=Sys;                %il controllo inv_S_N a 0
disp('Warning: sistema non invertibile con nessuna combinazione di elementi');
return