%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Flusso_Rotorico_An.m
%
% Coefficienti an dello sviluppo in serie del flusso rotorico conisderato 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Calcolo dei coefficienti degli sviluppi in serie dei flussi rotorici 

function An=Flusso_Rotorico_An(Tipo,n)

if Tipo(1)==1 % Trapezoidale
    al = Tipo(2);
    An=(n>=0).*(8*cos(al*n)./(pi*(pi-2*al)*n.^2));
    %
elseif Tipo(1)==2 % Ad_onda_quadra
    An=(n>=0).*(4*sin(n*pi/2)./(n*pi));
    %
elseif Tipo(1)==3 % Sinusoidale
    An=(n==1);
    %
elseif Tipo(1)==4 % Raccordo_cosinusoidale
    al = Tipo(2);
    An=(n>=0).*(4*pi*cos(al*n))./(n.^2.*(pi^2-4*al^2*n.^2)*(2*al/pi+pi/2-al));
    %
elseif Tipo(1)==5 % Raccordo_sinusoidale
    al = Tipo(2);
    An=(n>=0).*(4*pi*cos(al*n)).*sin(n*pi/2)./(n.*(pi^2-4*al^2*n.^2));
    %
elseif Tipo(1)==6 % Polinomiale_pari
    al = Tipo(2);
    q  = Tipo(3);
    somma1=0;
    somma2=0;
    for ii=[0:floor((q-1)/4)]
        somma1 = somma1+ (-1)^ii*coefbin((q-2)/2-ii,ii)*Prod_dis(ii,(q-4)/2-ii).*(al*n).^(2*ii);
        somma2 = somma2 + (-1)^(ii+1)*coefbin((q-2)/2-ii-1,ii)*Prod_dis(ii+1,(q-4)/2-ii).*(al*n).^(2*ii+1);
    end
    denom=pi/2-al*Prod_dis(floor((q+2)/4),(q-2)/2)./(factorial(floor((q)/4))*2^(floor(3*(q)/4)));
    An=(n>=0).*4.*(Prod_dis(1,(q-2)/2).*(somma1.*sin(al*n)+somma2.*cos(al*n)))./(denom*pi*al^(q-1).*n.^(q+1));
    %
elseif Tipo(1)==7 % Polinomiale_dispari
    al = Tipo(2);
    r  = Tipo(3);
    somma1=0;
    somma2=0;
    for ii=[0:floor(r/4)]
        somma1 = somma1+ (-1)^ii*coefbin((r-1)/2-ii,ii)*Prod_dis(ii,(r-3)/2-ii).*(al*n).^(2*ii);
        somma2 = somma2 + (-1)^(ii+1)*coefbin((r-1)/2-ii-1,ii)*Prod_dis(ii+1,(r-3)/2-ii).*(al*n).^(2*ii+1);
    end
    An=(n>=0).*4.*(Prod_dis(1,(r-1)/2).*(somma1.*sin(al*n)+somma2.*cos(al*n)).*sin(n*pi/2))./(pi*al^(r).*n.^(r+1));
    %
elseif Tipo(1)==8 % Derivata_trapezoidale
    al = Tipo(2);
    An=(n>=0).*(4*sin(al*n))./(pi*al*n.^3)./((pi-al)/2);
    %
    %%%%%%%%%%%%%%%% OK  (caso particolare del polinomiale pari q=2)
    % Tipo(1)  = 6;
    % Tipo(3)  = 2;
    % An=Flusso_Rotorico_An(Tipo,n);
    %
elseif Tipo(1)==9 % Fourier defined
    Nmax = Tipo(2);
    CompAi=Tipo(3:Nmax+3);
    An=0*n;
    for ii=[1:length(n)]
        if (n(ii)>=0)&(n(ii)<=Nmax)
            An(ii)=CompAi(n(ii)+1);
        else
            An(ii)=0;
        end
    end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Calcolo dei coefficienti binomiali
%%
%% y = coefbin(n,k)

function y = coefbin(n,k)

if n<0 | n<k
    y=0;
else
    y=nchoosek(n,k);
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Calcolo di una produttoria dispari
%%
%% y = Prod_dis(a,b)

function y = Prod_dis(a,b)

if a>b
    y=1;
else
    y=prod([1+2*a:2:1+2*b]);
end
