clear all
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   DEFINIZIONE DELLE UNITA' DI MISURA DEL SISTEMA INTERNAZIONALE (SI)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
metri = 1; dm = 0.1*metri; cm = 0.01*metri; mm = 0.001*metri; km = 1000*metri;
kg = 1;
N = 1;
kN = 1000*N;
secondo = 1; ora = 60*60*secondo;  minuti = 60*secondo;
ms = 0.001*secondo;
Pa = 1;
rad = 1;
gradi =( pi/180)*rad;
bar = 10^5*Pa;
lt = 0.001*metri^3;
rpm = 2*pi/60*rad/secondo;
g = 9.8*metri/secondo^2;
Volt=1; Amp=1; Ohm=Volt/Amp;
Henry=Volt*secondo/Amp; Weber=Volt*secondo;
Si=true; Yes=true; No=false;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% DEFINIZIONE E COMPOSIZIONE DEL SISTEMA %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

J_s=0.1; 
b_s=0; 
r_s=5*cm;

J_r=0.1;
b_r=0;
r_r=2*r_s;    %% n=2

J_c=0.15;
J_p=0;
b_c=0;
b_p=0;
r_p=(r_r-r_s)/2;
Nr_sat=2;

Wc_0=0;
Wr_0=0;

Tc_x=[0 4 4 6 6 10]';
Tc_y=[0 0 50 50 0 0]';

Tc=0.05*ms;                           % Switching period
Tfin=10*secondo;                      % Durata simulazione
Ts=Tfin/2000;

sim('Confronto_CVT_EMR_mdl',Tfin);    % Simulazione epicicloidale 

Lw=1.2;
figure(1)
clf
plot(t,Ws,'b','LineWidth',Lw)
hold on
plot(t,Wc,'r','LineWidth',Lw)
plot(t,Wr,'g','LineWidth',Lw)
title('Velocit del solare (b), portasatellite (r), ring (g)')
ylabel('W_c [rad/s]')
xlabel('Time [s]')
zoom on
grid on


