% function SysT=Componi_Sys(Sys1,Sys2,out1,in2,W)
%
% Questa funzione compone i due sistemi Sys1 e Sys2 passati dall'utente.
% L'algoritmo necessita di sapere quali uscite del primo sistema deve
% collegare con quali ingressi del secondo. 
% Viene inoltre dato il blocco di connessione W.
%

function SysT=Componi_Sys(Sys1,Sys2,out1,in2,W)

[nr_out nc_out]=size(out1);
if nc_out>nr_out                 % Se il numero di colonne  maggiore del 
    out1=out1.';                 % numero di righe ne faccio il trasposto
    [nr_out nc_out]=size(out1);  % e ricalcolo il numero di righe e colonne
end
[nr_in nc_in]=size(in2);
if nc_in>nr_in
    in2=in2.';
    [nr_in nc_in]=size(in2);
end
if (nc_out>1)|(nc_in>1)|(nc_in~=nc_out)                 % Se non sono   
   disp('Errore: (nc_out>1)|(nc_in>1)|(nc_in~=nc_out)') % vettori di 1 sola    
   return                                               % colonna da errore
end
if (Xi_Tutti_Diversi(out1)==0)|(Xi_Tutti_Diversi(in2)==0)  % Se ci sono due 
   disp('Errore: Ci sono due elementi uguali in out1 e/o in in2')% elementi
   return                                        % ugali esco con un errore
end

nrY1=size(Sys1.Y,1);
T=[];
X0=zeros(nrY1,1);
for ii=[1:nr_out]
    k=ismember(Sys1.Y,out1(ii));      % Creo la matrice T da applicare
    if (max(k)==1)                    % al primo sistema e controllo che
      T=[T k];                        % tutti gli elementi di out1
      X0=X0+k;                        % facciano parte di Y.
    else                                  
        disp('Errore: manca un elemento sul vettore Y delle uscite')
        return
    end
end
ind=find(X0==0);
En=eye(nrY1);
T=[En(:,ind) T];                      % Completo la matrice T
SysT1=Trasforma_UY_Sys(Sys1,T);       % Applico una trasformazione ingresso
                                      % uscita utilizzando la matrice T 
                                      % appena creata.
nrY2=size(Sys2.Y,1);
T=[];
X0=zeros(nrY2,1);
for ii=[1:nr_in]
    k=ismember(Sys2.U,in2(ii));       % Creo la matrice T da applicare
    if (max(k)==1)                    % al secondo sistema e controllo che
      T=[T k];                        % tutti gli elementi di in2 facciano
      X0=X0+k;                        % parte di U.
    else
        disp('Errore: manca un elemento sul vettore Y delle uscite')
        return
    end
end
ind=find(X0==0);
En=eye(nrY2);
T=[T En(:,ind)];                      % Completo la matrice T
SysT2=Trasforma_UY_Sys(Sys2,T);       % Applico una trasformazione ingresso
                                      % uscita utilizzando la matrice T 
                                      % appena creata.

SysT1=Separa_Sys(SysT1,size(SysT1.B,2)-nr_in);      % Scorporo i due sistemi per poter 
SysT2=Separa_Sys(SysT2,nr_out);                     % effettuare la composizione.

%Show_Generale(SysT1)
%Show_Generale(SysT2)

SysT=Componi_Generale(SysT1,SysT2,W); % Compongo i due sistemi
SysT=Compatta_Sys(SysT);           % Torno a compattare il sistema composto

return
