function Sys=Componi_Generale(Sys1,Sys2,W)


[nrW ncW]=size(W);                % Definisco le dimensioni della matrice W
nrYu=size(Sys1.Yu,1);             % Definisco le righe del vettore Yu
nrUi=size(Sys2.Ui,1);             % Definisco le righe del vettore Ui 

if (OK_Verifica(Sys1)*OK_Verifica(Sys2))==0
    disp('Uno dei due sistemi ha dimensioni incompatibili')
    Sys=0;                       
    return                       % Controllo che i due sistemi siano  
end                              % compatibili per la composizione.

if ncW~=nrYu
  disp('Il vettore Yu del sistema Sys1 non  compatibile con la matrice W')
  Sys=0;
  return                        % Controllo che i due vettori YU e Ui siano
end                             % compatibili con la matrice W.

if nrW~=nrUi
  disp('Il vettore Ui del sistema Sys2 non  compatibile con la matrice W')
  Sys=0;
  return
end

C11=inv(eye(ncW)+W.'*Sys2.Dii*W*Sys1.Duu)*W.'*Sys2.Dii*W; % Costruisco le 4
C12=inv(eye(ncW)+W.'*Sys2.Dii*W*Sys1.Duu)*W.';            % matrici che mi
C21=inv(eye(nrW)+W*Sys1.Duu*W.'*Sys2.Dii)*W;              % consentono di
C22=inv(eye(nrW)+W*Sys1.Duu*W.'*Sys2.Dii)*W*Sys1.Duu*W.'; % non avere loop.

Sys.L=mdiag(Sys1.L,Sys2.L);
Sys.mA=[Sys1.mA-Sys1.Bu*C11*Sys1.Cu, -Sys1.Bu*C12*Sys2.Ci;...
        Sys2.Bi*C21*Sys1.Cu, Sys2.mA-Sys2.Bi*C22*Sys2.Ci];
dimA=size(Sys.mA,1);
if size(Sys2.Bu,2)~=0
    Sys.Bu=[-Sys1.Bu*C12*Sys2.Dui ; Sys2.Bu-Sys2.Bi*C22*Sys2.Dui];
    Sys.Cu=[Sys2.Diu*C21*Sys1.Cu, Sys2.Cu-Sys2.Diu*C22*Sys2.Ci];
    Sys.Duu=Sys2.Duu-Sys2.Diu*C22*Sys2.Dui;    
else
    Sys.Bu=zeros(dimA,0);                   % Se Bu del secondo sistema o 
    Sys.Cu=zeros(0,dimA);                   % Bi del primo, hanno 
    Sys.Duu=zeros(0,0);                     % dimensioni nulle creo la  
end                                         % nuova matrice composizione 
                                            % utilizzando matrici nulle 
                                            % poich il simbolico non  in
                                            % grado di eseguire prodotti 
                                            % tra vettori o matrici vuote.
if size(Sys1.Bi,2)~=0
    Sys.Bi=[Sys1.Bi-Sys1.Bu*C11*Sys1.Diu ; Sys2.Bi*C21*Sys1.Diu];
    Sys.Ci=[Sys1.Ci-Sys1.Dui*C11*Sys1.Cu,-Sys1.Dui*C12*Sys2.Ci];
    Sys.Dii=Sys1.Dii-Sys1.Dui*C11*Sys1.Diu;
else
    Sys.Bi=zeros(dimA,0);
    Sys.Ci=zeros(0,dimA);
    Sys.Dii=zeros(0,0);
end

if (size(Sys2.Bu,2)~=0)&(size(Sys1.Bi,2)~=0)
    Sys.Dui=-Sys1.Dui*C12*Sys2.Dui;
    Sys.Diu=Sys2.Diu*C21*Sys1.Diu;
else
    Sys.Dui=zeros(size(Sys1.Ci,1),size(Sys2.Bu,2));
    Sys.Diu=zeros(size(Sys2.Cu,1),size(Sys1.Bi,2));
end


Sys.X=[Sys1.X;Sys2.X];                     
Sys.Ui=Sys1.Ui;
Sys.Uu=Sys2.Uu;
Sys.Yi=Sys1.Yi;
Sys.Yu=Sys2.Yu;

return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function D=mdiag(M1,M2)
%
% Questa funzione mi genera una matrice diagonale.
%

function D=mdiag(M1,M2)

%syms D
n1=size(M1);
n2=size(M2);
if (n1(1)~=n1(2))|(n2(1)~=n2(2))
    disp(n1);  disp(n2); disp('Dimensioni non corrette'); return
end
%D=zeros(n1(1)+n2(1));
D(1:n1(1),1:n1(1))=M1;
D(n1(1)+[1:n2(1)],n1(1)+[1:n2(1)])=M2;
return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function OK=OK_Verifica(Sys)
%
% Questa funzione controlla che il sistema esteso
% non sia viziato da errori.
%

function OK=OK_Verifica(Sys)

OK=1;

[nrL ncL]=size(Sys.L);
[nrBi ncBi]=size(Sys.Bi);
[nrBu ncBu]=size(Sys.Bu);
[nrCi ncCi]=size(Sys.Ci);
[nrCu ncCu]=size(Sys.Cu);
[nrDii ncDii]=size(Sys.Dii);              % Definisco le righe e le colonne 
[nrDiu ncDiu]=size(Sys.Diu);              %      delle varie matrici
[nrDui ncDui]=size(Sys.Dui);
[nrDuu ncDuu]=size(Sys.Duu);
[nrX ncX]=size(Sys.X);
[nrUi ncUi]=size(Sys.Ui);
[nrUu ncUu]=size(Sys.Uu);
[nrYi ncYi]=size(Sys.Yi);
[nrYu ncYu]=size(Sys.Yu);

if nrL~=ncL;    OK=0;    disp('Dimensioni non corrette della matrice L'); end
if nrL~=nrBi;   OK=0;    disp('Numero righe non compatibili delle matrici L e Bi'); end
if nrL~=nrBu;   OK=0;    disp('Numero righe non compatibili delle matrici L e Bu'); end
if ncL~=ncCi;   OK=0;    disp('Numero colonne non compatibili delle matrici L e Ci'); end
if ncL~=ncCu;   OK=0;    disp('Numero colonne non compatibili delle matrici L e Cu'); end
if ncX~=1;      OK=0;    disp('La variabile X non  un vettore'); end
if ncUi~=1;     OK=0;    disp('La variabile Ui non  un vettore'); end
if ncUu~=1;     OK=0;    disp('La variabile Uu non  un vettore'); end
if ncYi~=1;     OK=0;    disp('La variabile Yi non  un vettore'); end
if ncYu~=1;     OK=0;    disp('La variabile Yu non  un vettore'); end
if nrUi~=nrYi;  OK=0;    disp('I vettori Ui e Yi non sono compatibili'); end
if nrUu~=nrYu;  OK=0;    disp('I vettori Uu e Yu non sono compatibili'); end
if nrUi~=ncBi;  OK=0;    disp('Il vettore Ui non  compatibile con la matrice Bi'); end
if nrUu~=ncBu;  OK=0;    disp('Il vettore Uu non  compatibile con la matrice Bu'); end
if nrUi~=ncDii; OK=0;    disp('Il vettore Ui non  compatibile con la matrice Dii'); end
if nrUu~=ncDui; OK=0;    disp('Il vettore Uu non  compatibile con la matrice Diu'); end
if nrUi~=ncDiu; OK=0;    disp('Il vettore Ui non  compatibile con la matrice Dui'); end
if nrUu~=ncDuu; OK=0;    disp('Il vettore Uu non  compatibile con la matrice Duu'); end
if nrYi~=nrCi;  OK=0;    disp('Il vettore Yi non  compatibile con la matrice Ci'); end
if nrYu~=nrCu;  OK=0;    disp('Il vettore Yu non  compatibile con la matrice Cu'); end
if nrYi~=nrDii; OK=0;    disp('Il vettore Yi non  compatibile con la matrice Dii'); end
if nrYi~=nrDui; OK=0;    disp('Il vettore Yu non  compatibile con la matrice Diu'); end
if nrYu~=nrDiu; OK=0;    disp('Il vettore Yi non  compatibile con la matrice Dui'); end
if nrYu~=nrDuu; OK=0;    disp('Il vettore Yu non  compatibile con la matrice Duu'); end

return