% function SysT=Aggiungi_Ingresso_Sys(Sys,ix,ju,u_new,y_new)
%
% Questa funzione permette di aggiungere un eventuale ingresso/uscita
% di cui si e' persa traccia durante la composizione del sistema.
% Devono essere passati i seguenti parametri:
% - Sys= sistema a cui si deve aggiungere l'ingresso/uscita;
% - ix= indice i che ci dice su che variabile di stato si vuole agire;
% - ju= indice j che ci dice la posizione in cui si vuole inserire il nuovo
%       ingresso/usscita;
% - u_new= nuovo ingresso;
% - y_new= nuova uscita.
%

function SysT=Aggiungi_Ingresso_Sys(Sys,variabile,ju,u_new,y_new)
ix=find(ismember(Sys.X,variabile)==1);
SysT=Sys;

ncL=size(Sys.L,2);
ncB=size(Sys.B,2);
if ix>ncL                       % Se l'indice e' maggiore del numero di
    ix=ncL;                     % colonne lo si pone uguale all'ultima. 
    disp('Attenzione: si  posto ix=ncL')
end
if ju>(ncB+1)                   % Se l'indice e' maggiore del numero di
    ju=ncB+1;                   % colonne+1 lo si pone uguale all'ultima+1.
    disp('Attenzione: si  posto ju=ncB+1')
end

SysT.B=[Sys.B zeros(ncL,1)];
SysT.B(ix,ncB+1)=1;
SysT.U=[Sys.U; u_new];          % Definisco le nuove dimensioni e inserisco
SysT.C=[Sys.C; zeros(1,ncL)];   % i nuovi vettori alla fine di tutte le 
SysT.C(ncB+1,ix)=1;             % matrici e alla fine di tutti i vettori.
SysT.D=[Sys.D zeros(ncB,1)];
SysT.D=[SysT.D; zeros(1,ncB+1)];
SysT.Y=[Sys.Y; y_new];

T=eye(ncB+1);
T=[T(:,[1:ju-1]) T(:,ncB+1) T(:,[ju:ncB])];
SysT.B=SysT.B*T;
SysT.C=T.'*SysT.C;              % Ordino i vettori inseriti alla fine di
SysT.D=T.'*SysT.D*T;            % ogni matrice/vettore a seconda della  
SysT.U=T.'*SysT.U;              % posizione indicata da ju.
SysT.Y=T.'*SysT.Y;

return